<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetGeoZoneEventResult StructType
 * @subpackage Structs
 */
class GetGeoZoneEventResult extends AbstractStructBase
{
    /**
     * The ObcEventDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ObcEventDate;
    /**
     * The DatabaseRegistrationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatabaseRegistrationDate;
    /**
     * The GeoEventType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GeoEventType;
    /**
     * The Mileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Mileage;
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FuelLevel;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for GetGeoZoneEventResult
     * @uses GetGeoZoneEventResult::setObcEventDate()
     * @uses GetGeoZoneEventResult::setDatabaseRegistrationDate()
     * @uses GetGeoZoneEventResult::setGeoEventType()
     * @uses GetGeoZoneEventResult::setMileage()
     * @uses GetGeoZoneEventResult::setFuelLevel()
     * @uses GetGeoZoneEventResult::setDriver()
     * @uses GetGeoZoneEventResult::setTrailer()
     * @uses GetGeoZoneEventResult::setVehicle()
     * @uses GetGeoZoneEventResult::setPosition()
     * @uses GetGeoZoneEventResult::setCountryCode()
     * @param string $obcEventDate
     * @param string $databaseRegistrationDate
     * @param string $geoEventType
     * @param int $mileage
     * @param int $fuelLevel
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\Position $position
     * @param string $countryCode
     */
    public function __construct($obcEventDate = null, $databaseRegistrationDate = null, $geoEventType = null, $mileage = null, $fuelLevel = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\Position $position = null, $countryCode = null)
    {
        $this
            ->setObcEventDate($obcEventDate)
            ->setDatabaseRegistrationDate($databaseRegistrationDate)
            ->setGeoEventType($geoEventType)
            ->setMileage($mileage)
            ->setFuelLevel($fuelLevel)
            ->setDriver($driver)
            ->setTrailer($trailer)
            ->setVehicle($vehicle)
            ->setPosition($position)
            ->setCountryCode($countryCode);
    }
    /**
     * Get ObcEventDate value
     * @return string
     */
    public function getObcEventDate()
    {
        return $this->ObcEventDate;
    }
    /**
     * Set ObcEventDate value
     * @param string $obcEventDate
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setObcEventDate($obcEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($obcEventDate) && !is_string($obcEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obcEventDate, true), gettype($obcEventDate)), __LINE__);
        }
        $this->ObcEventDate = $obcEventDate;
        return $this;
    }
    /**
     * Get DatabaseRegistrationDate value
     * @return string
     */
    public function getDatabaseRegistrationDate()
    {
        return $this->DatabaseRegistrationDate;
    }
    /**
     * Set DatabaseRegistrationDate value
     * @param string $databaseRegistrationDate
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setDatabaseRegistrationDate($databaseRegistrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($databaseRegistrationDate) && !is_string($databaseRegistrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseRegistrationDate, true), gettype($databaseRegistrationDate)), __LINE__);
        }
        $this->DatabaseRegistrationDate = $databaseRegistrationDate;
        return $this;
    }
    /**
     * Get GeoEventType value
     * @return string
     */
    public function getGeoEventType()
    {
        return $this->GeoEventType;
    }
    /**
     * Set GeoEventType value
     * @uses \EnumType\EnumGeoEventType::valueIsValid()
     * @uses \EnumType\EnumGeoEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoEventType
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setGeoEventType($geoEventType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoEventType::valueIsValid($geoEventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGeoEventType', is_array($geoEventType) ? implode(', ', $geoEventType) : var_export($geoEventType, true), implode(', ', \EnumType\EnumGeoEventType::getValidValues())), __LINE__);
        }
        $this->GeoEventType = $geoEventType;
        return $this;
    }
    /**
     * Get Mileage value
     * @return int
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param int $mileage
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setMileage($mileage = null)
    {
        // validation for constraint: int
        if (!is_null($mileage) && !(is_int($mileage) || ctype_digit($mileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mileage, true), gettype($mileage)), __LINE__);
        }
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !(is_int($fuelLevel) || ctype_digit($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\GetGeoZoneEventResult
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
}
