<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetActivityReportDetailResult_V9 StructType
 * @subpackage Structs
 */
class GetActivityReportDetailResult_V9 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The ActivityReportDetailItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityReportDetailItem_V9
     */
    public $ActivityReportDetailItems;
    /**
     * Constructor method for GetActivityReportDetailResult_V9
     * @uses GetActivityReportDetailResult_V9::setMaximumModificationID()
     * @uses GetActivityReportDetailResult_V9::setActivityReportDetailItems()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfActivityReportDetailItem_V9 $activityReportDetailItems
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfActivityReportDetailItem_V9 $activityReportDetailItems = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setActivityReportDetailItems($activityReportDetailItems);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetActivityReportDetailResult_V9
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !(is_int($maximumModificationID) || ctype_digit($maximumModificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumModificationID, true), gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get ActivityReportDetailItems value
     * @return \ArrayType\ArrayOfActivityReportDetailItem_V9|null
     */
    public function getActivityReportDetailItems()
    {
        return $this->ActivityReportDetailItems;
    }
    /**
     * Set ActivityReportDetailItems value
     * @param \ArrayType\ArrayOfActivityReportDetailItem_V9 $activityReportDetailItems
     * @return \StructType\GetActivityReportDetailResult_V9
     */
    public function setActivityReportDetailItems(\ArrayType\ArrayOfActivityReportDetailItem_V9 $activityReportDetailItems = null)
    {
        $this->ActivityReportDetailItems = $activityReportDetailItems;
        return $this;
    }
}
