<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeofencingResult StructType
 * @subpackage Structs
 */
class GeofencingResult extends Geofencing
{
    /**
     * The GeoEventDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $GeoEventDate;
    /**
     * Constructor method for GeofencingResult
     * @uses GeofencingResult::setGeoEventDate()
     * @param string $geoEventDate
     */
    public function __construct($geoEventDate = null)
    {
        $this
            ->setGeoEventDate($geoEventDate);
    }
    /**
     * Get GeoEventDate value
     * @return string
     */
    public function getGeoEventDate()
    {
        return $this->GeoEventDate;
    }
    /**
     * Set GeoEventDate value
     * @param string $geoEventDate
     * @return \StructType\GeofencingResult
     */
    public function setGeoEventDate($geoEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($geoEventDate) && !is_string($geoEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoEventDate, true), gettype($geoEventDate)), __LINE__);
        }
        $this->GeoEventDate = $geoEventDate;
        return $this;
    }
}
