<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoFenceSelection StructType
 * @subpackage Structs
 */
class GeoFenceSelection extends AbstractStructBase
{
    /**
     * The IncludeInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeInactive;
    /**
     * The IncludeLinkedVehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeLinkedVehicles;
    /**
     * The GeoFences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierGeoFence
     */
    public $GeoFences;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * Constructor method for GeoFenceSelection
     * @uses GeoFenceSelection::setIncludeInactive()
     * @uses GeoFenceSelection::setIncludeLinkedVehicles()
     * @uses GeoFenceSelection::setGeoFences()
     * @uses GeoFenceSelection::setVehicle()
     * @param bool $includeInactive
     * @param bool $includeLinkedVehicles
     * @param \ArrayType\ArrayOfIdentifierGeoFence $geoFences
     * @param \StructType\IdentifierVehicle $vehicle
     */
    public function __construct($includeInactive = null, $includeLinkedVehicles = null, \ArrayType\ArrayOfIdentifierGeoFence $geoFences = null, \StructType\IdentifierVehicle $vehicle = null)
    {
        $this
            ->setIncludeInactive($includeInactive)
            ->setIncludeLinkedVehicles($includeLinkedVehicles)
            ->setGeoFences($geoFences)
            ->setVehicle($vehicle);
    }
    /**
     * Get IncludeInactive value
     * @return bool
     */
    public function getIncludeInactive()
    {
        return $this->IncludeInactive;
    }
    /**
     * Set IncludeInactive value
     * @param bool $includeInactive
     * @return \StructType\GeoFenceSelection
     */
    public function setIncludeInactive($includeInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactive) && !is_bool($includeInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInactive, true), gettype($includeInactive)), __LINE__);
        }
        $this->IncludeInactive = $includeInactive;
        return $this;
    }
    /**
     * Get IncludeLinkedVehicles value
     * @return bool
     */
    public function getIncludeLinkedVehicles()
    {
        return $this->IncludeLinkedVehicles;
    }
    /**
     * Set IncludeLinkedVehicles value
     * @param bool $includeLinkedVehicles
     * @return \StructType\GeoFenceSelection
     */
    public function setIncludeLinkedVehicles($includeLinkedVehicles = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeLinkedVehicles) && !is_bool($includeLinkedVehicles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeLinkedVehicles, true), gettype($includeLinkedVehicles)), __LINE__);
        }
        $this->IncludeLinkedVehicles = $includeLinkedVehicles;
        return $this;
    }
    /**
     * Get GeoFences value
     * @return \ArrayType\ArrayOfIdentifierGeoFence|null
     */
    public function getGeoFences()
    {
        return $this->GeoFences;
    }
    /**
     * Set GeoFences value
     * @param \ArrayType\ArrayOfIdentifierGeoFence $geoFences
     * @return \StructType\GeoFenceSelection
     */
    public function setGeoFences(\ArrayType\ArrayOfIdentifierGeoFence $geoFences = null)
    {
        $this->GeoFences = $geoFences;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\GeoFenceSelection
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
}
