<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoFenceResult_v2 StructType
 * @subpackage Structs
 */
class GeoFenceResult_v2 extends AbstractStructBase
{
    /**
     * The GeoFenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeoFenceID;
    /**
     * The GeoFenceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GeoFenceName;
    /**
     * The GeoZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeoZoneResult_v2
     */
    public $GeoZone;
    /**
     * Constructor method for GeoFenceResult_v2
     * @uses GeoFenceResult_v2::setGeoFenceID()
     * @uses GeoFenceResult_v2::setGeoFenceName()
     * @uses GeoFenceResult_v2::setGeoZone()
     * @param int $geoFenceID
     * @param string $geoFenceName
     * @param \StructType\GeoZoneResult_v2 $geoZone
     */
    public function __construct($geoFenceID = null, $geoFenceName = null, \StructType\GeoZoneResult_v2 $geoZone = null)
    {
        $this
            ->setGeoFenceID($geoFenceID)
            ->setGeoFenceName($geoFenceName)
            ->setGeoZone($geoZone);
    }
    /**
     * Get GeoFenceID value
     * @return int
     */
    public function getGeoFenceID()
    {
        return $this->GeoFenceID;
    }
    /**
     * Set GeoFenceID value
     * @param int $geoFenceID
     * @return \StructType\GeoFenceResult_v2
     */
    public function setGeoFenceID($geoFenceID = null)
    {
        // validation for constraint: int
        if (!is_null($geoFenceID) && !(is_int($geoFenceID) || ctype_digit($geoFenceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geoFenceID, true), gettype($geoFenceID)), __LINE__);
        }
        $this->GeoFenceID = $geoFenceID;
        return $this;
    }
    /**
     * Get GeoFenceName value
     * @return string|null
     */
    public function getGeoFenceName()
    {
        return $this->GeoFenceName;
    }
    /**
     * Set GeoFenceName value
     * @param string $geoFenceName
     * @return \StructType\GeoFenceResult_v2
     */
    public function setGeoFenceName($geoFenceName = null)
    {
        // validation for constraint: string
        if (!is_null($geoFenceName) && !is_string($geoFenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoFenceName, true), gettype($geoFenceName)), __LINE__);
        }
        $this->GeoFenceName = $geoFenceName;
        return $this;
    }
    /**
     * Get GeoZone value
     * @return \StructType\GeoZoneResult_v2|null
     */
    public function getGeoZone()
    {
        return $this->GeoZone;
    }
    /**
     * Set GeoZone value
     * @param \StructType\GeoZoneResult_v2 $geoZone
     * @return \StructType\GeoFenceResult_v2
     */
    public function setGeoZone(\StructType\GeoZoneResult_v2 $geoZone = null)
    {
        $this->GeoZone = $geoZone;
        return $this;
    }
}
