<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericBaseItem StructType
 * @subpackage Structs
 */
class GenericBaseItem extends AbstractStructBase
{
    /**
     * The Min
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Min;
    /**
     * The Max
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Max;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for GenericBaseItem
     * @uses GenericBaseItem::setMin()
     * @uses GenericBaseItem::setMax()
     * @uses GenericBaseItem::setValue()
     * @uses GenericBaseItem::setName()
     * @uses GenericBaseItem::setType()
     * @param float $min
     * @param float $max
     * @param float $value
     * @param string $name
     * @param string $type
     */
    public function __construct($min = null, $max = null, $value = null, $name = null, $type = null)
    {
        $this
            ->setMin($min)
            ->setMax($max)
            ->setValue($value)
            ->setName($name)
            ->setType($type);
    }
    /**
     * Get Min value
     * @return float
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param float $min
     * @return \StructType\GenericBaseItem
     */
    public function setMin($min = null)
    {
        // validation for constraint: float
        if (!is_null($min) && !(is_float($min) || is_numeric($min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($min, true), gettype($min)), __LINE__);
        }
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return float
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param float $max
     * @return \StructType\GenericBaseItem
     */
    public function setMax($max = null)
    {
        // validation for constraint: float
        if (!is_null($max) && !(is_float($max) || is_numeric($max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max, true), gettype($max)), __LINE__);
        }
        $this->Max = $max;
        return $this;
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\GenericBaseItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GenericBaseItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\GenericBaseItem
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
