<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileSend StructType
 * @subpackage Structs
 */
class FileSend extends AbstractStructBase
{
    /**
     * The File
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FileInfo
     */
    public $File;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The ExistingFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierFile
     */
    public $ExistingFile;
    /**
     * Constructor method for FileSend
     * @uses FileSend::setFile()
     * @uses FileSend::setVehicles()
     * @uses FileSend::setDrivers()
     * @uses FileSend::setExistingFile()
     * @param \StructType\FileInfo $file
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \StructType\IdentifierFile $existingFile
     */
    public function __construct(\StructType\FileInfo $file = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifier $drivers = null, \StructType\IdentifierFile $existingFile = null)
    {
        $this
            ->setFile($file)
            ->setVehicles($vehicles)
            ->setDrivers($drivers)
            ->setExistingFile($existingFile);
    }
    /**
     * Get File value
     * @return \StructType\FileInfo|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @param \StructType\FileInfo $file
     * @return \StructType\FileSend
     */
    public function setFile(\StructType\FileInfo $file = null)
    {
        $this->File = $file;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\FileSend
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\FileSend
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get ExistingFile value
     * @return \StructType\IdentifierFile|null
     */
    public function getExistingFile()
    {
        return $this->ExistingFile;
    }
    /**
     * Set ExistingFile value
     * @param \StructType\IdentifierFile $existingFile
     * @return \StructType\FileSend
     */
    public function setExistingFile(\StructType\IdentifierFile $existingFile = null)
    {
        $this->ExistingFile = $existingFile;
        return $this;
    }
}
