<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportViaRouteResult StructType
 * @subpackage Structs
 */
class ExportViaRouteResult extends ExecutionResult
{
    /**
     * The Gpx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gpx;
    /**
     * Constructor method for ExportViaRouteResult
     * @uses ExportViaRouteResult::setGpx()
     * @param string $gpx
     */
    public function __construct($gpx = null)
    {
        $this
            ->setGpx($gpx);
    }
    /**
     * Get Gpx value
     * @return string|null
     */
    public function getGpx()
    {
        return $this->Gpx;
    }
    /**
     * Set Gpx value
     * @param string $gpx
     * @return \StructType\ExportViaRouteResult
     */
    public function setGpx($gpx = null)
    {
        // validation for constraint: string
        if (!is_null($gpx) && !is_string($gpx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gpx, true), gettype($gpx)), __LINE__);
        }
        $this->Gpx = $gpx;
        return $this;
    }
}
