<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EngineloadRPMItemsPerDriver StructType
 * @subpackage Structs
 */
class EngineloadRPMItemsPerDriver extends AbstractStructBase
{
    /**
     * The DriverTechnicalNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverTechnicalNumber;
    /**
     * The EngineloadRPMList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEngineloadRPMItem
     */
    public $EngineloadRPMList;
    /**
     * Constructor method for EngineloadRPMItemsPerDriver
     * @uses EngineloadRPMItemsPerDriver::setDriverTechnicalNumber()
     * @uses EngineloadRPMItemsPerDriver::setEngineloadRPMList()
     * @param int $driverTechnicalNumber
     * @param \ArrayType\ArrayOfEngineloadRPMItem $engineloadRPMList
     */
    public function __construct($driverTechnicalNumber = null, \ArrayType\ArrayOfEngineloadRPMItem $engineloadRPMList = null)
    {
        $this
            ->setDriverTechnicalNumber($driverTechnicalNumber)
            ->setEngineloadRPMList($engineloadRPMList);
    }
    /**
     * Get DriverTechnicalNumber value
     * @return int
     */
    public function getDriverTechnicalNumber()
    {
        return $this->DriverTechnicalNumber;
    }
    /**
     * Set DriverTechnicalNumber value
     * @param int $driverTechnicalNumber
     * @return \StructType\EngineloadRPMItemsPerDriver
     */
    public function setDriverTechnicalNumber($driverTechnicalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($driverTechnicalNumber) && !(is_int($driverTechnicalNumber) || ctype_digit($driverTechnicalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverTechnicalNumber, true), gettype($driverTechnicalNumber)), __LINE__);
        }
        $this->DriverTechnicalNumber = $driverTechnicalNumber;
        return $this;
    }
    /**
     * Get EngineloadRPMList value
     * @return \ArrayType\ArrayOfEngineloadRPMItem|null
     */
    public function getEngineloadRPMList()
    {
        return $this->EngineloadRPMList;
    }
    /**
     * Set EngineloadRPMList value
     * @param \ArrayType\ArrayOfEngineloadRPMItem $engineloadRPMList
     * @return \StructType\EngineloadRPMItemsPerDriver
     */
    public function setEngineloadRPMList(\ArrayType\ArrayOfEngineloadRPMItem $engineloadRPMList = null)
    {
        $this->EngineloadRPMList = $engineloadRPMList;
        return $this;
    }
}
