<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoPerformanceInfo StructType
 * @subpackage Structs
 */
class EcoPerformanceInfo extends AbstractStructBase
{
    /**
     * The EcoDistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EcoDistance;
    /**
     * The EcoDrivingTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EcoDrivingTime;
    /**
     * The AverageAxleWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageAxleWeight;
    /**
     * The AltitudeVariations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AltitudeVariations;
    /**
     * Constructor method for EcoPerformanceInfo
     * @uses EcoPerformanceInfo::setEcoDistance()
     * @uses EcoPerformanceInfo::setEcoDrivingTime()
     * @uses EcoPerformanceInfo::setAverageAxleWeight()
     * @uses EcoPerformanceInfo::setAltitudeVariations()
     * @param float $ecoDistance
     * @param int $ecoDrivingTime
     * @param float $averageAxleWeight
     * @param float $altitudeVariations
     */
    public function __construct($ecoDistance = null, $ecoDrivingTime = null, $averageAxleWeight = null, $altitudeVariations = null)
    {
        $this
            ->setEcoDistance($ecoDistance)
            ->setEcoDrivingTime($ecoDrivingTime)
            ->setAverageAxleWeight($averageAxleWeight)
            ->setAltitudeVariations($altitudeVariations);
    }
    /**
     * Get EcoDistance value
     * @return float
     */
    public function getEcoDistance()
    {
        return $this->EcoDistance;
    }
    /**
     * Set EcoDistance value
     * @param float $ecoDistance
     * @return \StructType\EcoPerformanceInfo
     */
    public function setEcoDistance($ecoDistance = null)
    {
        // validation for constraint: float
        if (!is_null($ecoDistance) && !(is_float($ecoDistance) || is_numeric($ecoDistance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ecoDistance, true), gettype($ecoDistance)), __LINE__);
        }
        $this->EcoDistance = $ecoDistance;
        return $this;
    }
    /**
     * Get EcoDrivingTime value
     * @return int
     */
    public function getEcoDrivingTime()
    {
        return $this->EcoDrivingTime;
    }
    /**
     * Set EcoDrivingTime value
     * @param int $ecoDrivingTime
     * @return \StructType\EcoPerformanceInfo
     */
    public function setEcoDrivingTime($ecoDrivingTime = null)
    {
        // validation for constraint: int
        if (!is_null($ecoDrivingTime) && !(is_int($ecoDrivingTime) || ctype_digit($ecoDrivingTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ecoDrivingTime, true), gettype($ecoDrivingTime)), __LINE__);
        }
        $this->EcoDrivingTime = $ecoDrivingTime;
        return $this;
    }
    /**
     * Get AverageAxleWeight value
     * @return float
     */
    public function getAverageAxleWeight()
    {
        return $this->AverageAxleWeight;
    }
    /**
     * Set AverageAxleWeight value
     * @param float $averageAxleWeight
     * @return \StructType\EcoPerformanceInfo
     */
    public function setAverageAxleWeight($averageAxleWeight = null)
    {
        // validation for constraint: float
        if (!is_null($averageAxleWeight) && !(is_float($averageAxleWeight) || is_numeric($averageAxleWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageAxleWeight, true), gettype($averageAxleWeight)), __LINE__);
        }
        $this->AverageAxleWeight = $averageAxleWeight;
        return $this;
    }
    /**
     * Get AltitudeVariations value
     * @return float
     */
    public function getAltitudeVariations()
    {
        return $this->AltitudeVariations;
    }
    /**
     * Set AltitudeVariations value
     * @param float $altitudeVariations
     * @return \StructType\EcoPerformanceInfo
     */
    public function setAltitudeVariations($altitudeVariations = null)
    {
        // validation for constraint: float
        if (!is_null($altitudeVariations) && !(is_float($altitudeVariations) || is_numeric($altitudeVariations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altitudeVariations, true), gettype($altitudeVariations)), __LINE__);
        }
        $this->AltitudeVariations = $altitudeVariations;
        return $this;
    }
}
