<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoPerformanceData StructType
 * @subpackage Structs
 */
class EcoPerformanceData extends AbstractStructBase
{
    /**
     * The AverageCO2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageCO2;
    /**
     * The AverageFuelConsumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageFuelConsumption;
    /**
     * The AverageSpeed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageSpeed;
    /**
     * The DurationIdling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationIdling;
    /**
     * The HighRpm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $HighRpm;
    /**
     * The Overspeeding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Overspeeding;
    /**
     * The Coasting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Coasting;
    /**
     * The PanicBraking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PanicBraking;
    /**
     * The DurationRetarder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationRetarder;
    /**
     * The DistanceCruiseControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceCruiseControl;
    /**
     * The Stops100Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Stops100Km;
    /**
     * The Braking100Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Braking100Km;
    /**
     * The GearingInGreenSpot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $GearingInGreenSpot;
    /**
     * The TopSpeedFluctuations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TopSpeedFluctuations;
    /**
     * The RedRpm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RedRpm;
    /**
     * Constructor method for EcoPerformanceData
     * @uses EcoPerformanceData::setAverageCO2()
     * @uses EcoPerformanceData::setAverageFuelConsumption()
     * @uses EcoPerformanceData::setAverageSpeed()
     * @uses EcoPerformanceData::setDurationIdling()
     * @uses EcoPerformanceData::setHighRpm()
     * @uses EcoPerformanceData::setOverspeeding()
     * @uses EcoPerformanceData::setCoasting()
     * @uses EcoPerformanceData::setPanicBraking()
     * @uses EcoPerformanceData::setDurationRetarder()
     * @uses EcoPerformanceData::setDistanceCruiseControl()
     * @uses EcoPerformanceData::setStops100Km()
     * @uses EcoPerformanceData::setBraking100Km()
     * @uses EcoPerformanceData::setGearingInGreenSpot()
     * @uses EcoPerformanceData::setTopSpeedFluctuations()
     * @uses EcoPerformanceData::setRedRpm()
     * @param float $averageCO2
     * @param float $averageFuelConsumption
     * @param float $averageSpeed
     * @param float $durationIdling
     * @param float $highRpm
     * @param float $overspeeding
     * @param float $coasting
     * @param float $panicBraking
     * @param float $durationRetarder
     * @param float $distanceCruiseControl
     * @param float $stops100Km
     * @param float $braking100Km
     * @param float $gearingInGreenSpot
     * @param float $topSpeedFluctuations
     * @param float $redRpm
     */
    public function __construct($averageCO2 = null, $averageFuelConsumption = null, $averageSpeed = null, $durationIdling = null, $highRpm = null, $overspeeding = null, $coasting = null, $panicBraking = null, $durationRetarder = null, $distanceCruiseControl = null, $stops100Km = null, $braking100Km = null, $gearingInGreenSpot = null, $topSpeedFluctuations = null, $redRpm = null)
    {
        $this
            ->setAverageCO2($averageCO2)
            ->setAverageFuelConsumption($averageFuelConsumption)
            ->setAverageSpeed($averageSpeed)
            ->setDurationIdling($durationIdling)
            ->setHighRpm($highRpm)
            ->setOverspeeding($overspeeding)
            ->setCoasting($coasting)
            ->setPanicBraking($panicBraking)
            ->setDurationRetarder($durationRetarder)
            ->setDistanceCruiseControl($distanceCruiseControl)
            ->setStops100Km($stops100Km)
            ->setBraking100Km($braking100Km)
            ->setGearingInGreenSpot($gearingInGreenSpot)
            ->setTopSpeedFluctuations($topSpeedFluctuations)
            ->setRedRpm($redRpm);
    }
    /**
     * Get AverageCO2 value
     * @return float
     */
    public function getAverageCO2()
    {
        return $this->AverageCO2;
    }
    /**
     * Set AverageCO2 value
     * @param float $averageCO2
     * @return \StructType\EcoPerformanceData
     */
    public function setAverageCO2($averageCO2 = null)
    {
        // validation for constraint: float
        if (!is_null($averageCO2) && !(is_float($averageCO2) || is_numeric($averageCO2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageCO2, true), gettype($averageCO2)), __LINE__);
        }
        $this->AverageCO2 = $averageCO2;
        return $this;
    }
    /**
     * Get AverageFuelConsumption value
     * @return float
     */
    public function getAverageFuelConsumption()
    {
        return $this->AverageFuelConsumption;
    }
    /**
     * Set AverageFuelConsumption value
     * @param float $averageFuelConsumption
     * @return \StructType\EcoPerformanceData
     */
    public function setAverageFuelConsumption($averageFuelConsumption = null)
    {
        // validation for constraint: float
        if (!is_null($averageFuelConsumption) && !(is_float($averageFuelConsumption) || is_numeric($averageFuelConsumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageFuelConsumption, true), gettype($averageFuelConsumption)), __LINE__);
        }
        $this->AverageFuelConsumption = $averageFuelConsumption;
        return $this;
    }
    /**
     * Get AverageSpeed value
     * @return float
     */
    public function getAverageSpeed()
    {
        return $this->AverageSpeed;
    }
    /**
     * Set AverageSpeed value
     * @param float $averageSpeed
     * @return \StructType\EcoPerformanceData
     */
    public function setAverageSpeed($averageSpeed = null)
    {
        // validation for constraint: float
        if (!is_null($averageSpeed) && !(is_float($averageSpeed) || is_numeric($averageSpeed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageSpeed, true), gettype($averageSpeed)), __LINE__);
        }
        $this->AverageSpeed = $averageSpeed;
        return $this;
    }
    /**
     * Get DurationIdling value
     * @return float
     */
    public function getDurationIdling()
    {
        return $this->DurationIdling;
    }
    /**
     * Set DurationIdling value
     * @param float $durationIdling
     * @return \StructType\EcoPerformanceData
     */
    public function setDurationIdling($durationIdling = null)
    {
        // validation for constraint: float
        if (!is_null($durationIdling) && !(is_float($durationIdling) || is_numeric($durationIdling))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationIdling, true), gettype($durationIdling)), __LINE__);
        }
        $this->DurationIdling = $durationIdling;
        return $this;
    }
    /**
     * Get HighRpm value
     * @return float
     */
    public function getHighRpm()
    {
        return $this->HighRpm;
    }
    /**
     * Set HighRpm value
     * @param float $highRpm
     * @return \StructType\EcoPerformanceData
     */
    public function setHighRpm($highRpm = null)
    {
        // validation for constraint: float
        if (!is_null($highRpm) && !(is_float($highRpm) || is_numeric($highRpm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($highRpm, true), gettype($highRpm)), __LINE__);
        }
        $this->HighRpm = $highRpm;
        return $this;
    }
    /**
     * Get Overspeeding value
     * @return float
     */
    public function getOverspeeding()
    {
        return $this->Overspeeding;
    }
    /**
     * Set Overspeeding value
     * @param float $overspeeding
     * @return \StructType\EcoPerformanceData
     */
    public function setOverspeeding($overspeeding = null)
    {
        // validation for constraint: float
        if (!is_null($overspeeding) && !(is_float($overspeeding) || is_numeric($overspeeding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overspeeding, true), gettype($overspeeding)), __LINE__);
        }
        $this->Overspeeding = $overspeeding;
        return $this;
    }
    /**
     * Get Coasting value
     * @return float
     */
    public function getCoasting()
    {
        return $this->Coasting;
    }
    /**
     * Set Coasting value
     * @param float $coasting
     * @return \StructType\EcoPerformanceData
     */
    public function setCoasting($coasting = null)
    {
        // validation for constraint: float
        if (!is_null($coasting) && !(is_float($coasting) || is_numeric($coasting))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coasting, true), gettype($coasting)), __LINE__);
        }
        $this->Coasting = $coasting;
        return $this;
    }
    /**
     * Get PanicBraking value
     * @return float
     */
    public function getPanicBraking()
    {
        return $this->PanicBraking;
    }
    /**
     * Set PanicBraking value
     * @param float $panicBraking
     * @return \StructType\EcoPerformanceData
     */
    public function setPanicBraking($panicBraking = null)
    {
        // validation for constraint: float
        if (!is_null($panicBraking) && !(is_float($panicBraking) || is_numeric($panicBraking))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($panicBraking, true), gettype($panicBraking)), __LINE__);
        }
        $this->PanicBraking = $panicBraking;
        return $this;
    }
    /**
     * Get DurationRetarder value
     * @return float
     */
    public function getDurationRetarder()
    {
        return $this->DurationRetarder;
    }
    /**
     * Set DurationRetarder value
     * @param float $durationRetarder
     * @return \StructType\EcoPerformanceData
     */
    public function setDurationRetarder($durationRetarder = null)
    {
        // validation for constraint: float
        if (!is_null($durationRetarder) && !(is_float($durationRetarder) || is_numeric($durationRetarder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationRetarder, true), gettype($durationRetarder)), __LINE__);
        }
        $this->DurationRetarder = $durationRetarder;
        return $this;
    }
    /**
     * Get DistanceCruiseControl value
     * @return float
     */
    public function getDistanceCruiseControl()
    {
        return $this->DistanceCruiseControl;
    }
    /**
     * Set DistanceCruiseControl value
     * @param float $distanceCruiseControl
     * @return \StructType\EcoPerformanceData
     */
    public function setDistanceCruiseControl($distanceCruiseControl = null)
    {
        // validation for constraint: float
        if (!is_null($distanceCruiseControl) && !(is_float($distanceCruiseControl) || is_numeric($distanceCruiseControl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceCruiseControl, true), gettype($distanceCruiseControl)), __LINE__);
        }
        $this->DistanceCruiseControl = $distanceCruiseControl;
        return $this;
    }
    /**
     * Get Stops100Km value
     * @return float
     */
    public function getStops100Km()
    {
        return $this->Stops100Km;
    }
    /**
     * Set Stops100Km value
     * @param float $stops100Km
     * @return \StructType\EcoPerformanceData
     */
    public function setStops100Km($stops100Km = null)
    {
        // validation for constraint: float
        if (!is_null($stops100Km) && !(is_float($stops100Km) || is_numeric($stops100Km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($stops100Km, true), gettype($stops100Km)), __LINE__);
        }
        $this->Stops100Km = $stops100Km;
        return $this;
    }
    /**
     * Get Braking100Km value
     * @return float
     */
    public function getBraking100Km()
    {
        return $this->Braking100Km;
    }
    /**
     * Set Braking100Km value
     * @param float $braking100Km
     * @return \StructType\EcoPerformanceData
     */
    public function setBraking100Km($braking100Km = null)
    {
        // validation for constraint: float
        if (!is_null($braking100Km) && !(is_float($braking100Km) || is_numeric($braking100Km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($braking100Km, true), gettype($braking100Km)), __LINE__);
        }
        $this->Braking100Km = $braking100Km;
        return $this;
    }
    /**
     * Get GearingInGreenSpot value
     * @return float
     */
    public function getGearingInGreenSpot()
    {
        return $this->GearingInGreenSpot;
    }
    /**
     * Set GearingInGreenSpot value
     * @param float $gearingInGreenSpot
     * @return \StructType\EcoPerformanceData
     */
    public function setGearingInGreenSpot($gearingInGreenSpot = null)
    {
        // validation for constraint: float
        if (!is_null($gearingInGreenSpot) && !(is_float($gearingInGreenSpot) || is_numeric($gearingInGreenSpot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gearingInGreenSpot, true), gettype($gearingInGreenSpot)), __LINE__);
        }
        $this->GearingInGreenSpot = $gearingInGreenSpot;
        return $this;
    }
    /**
     * Get TopSpeedFluctuations value
     * @return float
     */
    public function getTopSpeedFluctuations()
    {
        return $this->TopSpeedFluctuations;
    }
    /**
     * Set TopSpeedFluctuations value
     * @param float $topSpeedFluctuations
     * @return \StructType\EcoPerformanceData
     */
    public function setTopSpeedFluctuations($topSpeedFluctuations = null)
    {
        // validation for constraint: float
        if (!is_null($topSpeedFluctuations) && !(is_float($topSpeedFluctuations) || is_numeric($topSpeedFluctuations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($topSpeedFluctuations, true), gettype($topSpeedFluctuations)), __LINE__);
        }
        $this->TopSpeedFluctuations = $topSpeedFluctuations;
        return $this;
    }
    /**
     * Get RedRpm value
     * @return float
     */
    public function getRedRpm()
    {
        return $this->RedRpm;
    }
    /**
     * Set RedRpm value
     * @param float $redRpm
     * @return \StructType\EcoPerformanceData
     */
    public function setRedRpm($redRpm = null)
    {
        // validation for constraint: float
        if (!is_null($redRpm) && !(is_float($redRpm) || is_numeric($redRpm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redRpm, true), gettype($redRpm)), __LINE__);
        }
        $this->RedRpm = $redRpm;
        return $this;
    }
}
