<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorMaxGearResult StructType
 * @subpackage Structs
 */
class EcoMonitorMaxGearResult extends AbstractStructBase
{
    /**
     * The DistanceInKilometers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DistanceInKilometers;
    /**
     * The TopSpeedTotalFuelUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TopSpeedTotalFuelUsage;
    /**
     * The FuelConsumptionInLiterPer100Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelConsumptionInLiterPer100Km;
    /**
     * The FuelConsumptionInKmPerLiter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelConsumptionInKmPerLiter;
    /**
     * The DurationInSec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DurationInSec;
    /**
     * Constructor method for EcoMonitorMaxGearResult
     * @uses EcoMonitorMaxGearResult::setDistanceInKilometers()
     * @uses EcoMonitorMaxGearResult::setTopSpeedTotalFuelUsage()
     * @uses EcoMonitorMaxGearResult::setFuelConsumptionInLiterPer100Km()
     * @uses EcoMonitorMaxGearResult::setFuelConsumptionInKmPerLiter()
     * @uses EcoMonitorMaxGearResult::setDurationInSec()
     * @param float $distanceInKilometers
     * @param float $topSpeedTotalFuelUsage
     * @param float $fuelConsumptionInLiterPer100Km
     * @param float $fuelConsumptionInKmPerLiter
     * @param int $durationInSec
     */
    public function __construct($distanceInKilometers = null, $topSpeedTotalFuelUsage = null, $fuelConsumptionInLiterPer100Km = null, $fuelConsumptionInKmPerLiter = null, $durationInSec = null)
    {
        $this
            ->setDistanceInKilometers($distanceInKilometers)
            ->setTopSpeedTotalFuelUsage($topSpeedTotalFuelUsage)
            ->setFuelConsumptionInLiterPer100Km($fuelConsumptionInLiterPer100Km)
            ->setFuelConsumptionInKmPerLiter($fuelConsumptionInKmPerLiter)
            ->setDurationInSec($durationInSec);
    }
    /**
     * Get DistanceInKilometers value
     * @return float
     */
    public function getDistanceInKilometers()
    {
        return $this->DistanceInKilometers;
    }
    /**
     * Set DistanceInKilometers value
     * @param float $distanceInKilometers
     * @return \StructType\EcoMonitorMaxGearResult
     */
    public function setDistanceInKilometers($distanceInKilometers = null)
    {
        // validation for constraint: float
        if (!is_null($distanceInKilometers) && !(is_float($distanceInKilometers) || is_numeric($distanceInKilometers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceInKilometers, true), gettype($distanceInKilometers)), __LINE__);
        }
        $this->DistanceInKilometers = $distanceInKilometers;
        return $this;
    }
    /**
     * Get TopSpeedTotalFuelUsage value
     * @return float
     */
    public function getTopSpeedTotalFuelUsage()
    {
        return $this->TopSpeedTotalFuelUsage;
    }
    /**
     * Set TopSpeedTotalFuelUsage value
     * @param float $topSpeedTotalFuelUsage
     * @return \StructType\EcoMonitorMaxGearResult
     */
    public function setTopSpeedTotalFuelUsage($topSpeedTotalFuelUsage = null)
    {
        // validation for constraint: float
        if (!is_null($topSpeedTotalFuelUsage) && !(is_float($topSpeedTotalFuelUsage) || is_numeric($topSpeedTotalFuelUsage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($topSpeedTotalFuelUsage, true), gettype($topSpeedTotalFuelUsage)), __LINE__);
        }
        $this->TopSpeedTotalFuelUsage = $topSpeedTotalFuelUsage;
        return $this;
    }
    /**
     * Get FuelConsumptionInLiterPer100Km value
     * @return float
     */
    public function getFuelConsumptionInLiterPer100Km()
    {
        return $this->FuelConsumptionInLiterPer100Km;
    }
    /**
     * Set FuelConsumptionInLiterPer100Km value
     * @param float $fuelConsumptionInLiterPer100Km
     * @return \StructType\EcoMonitorMaxGearResult
     */
    public function setFuelConsumptionInLiterPer100Km($fuelConsumptionInLiterPer100Km = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionInLiterPer100Km) && !(is_float($fuelConsumptionInLiterPer100Km) || is_numeric($fuelConsumptionInLiterPer100Km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionInLiterPer100Km, true), gettype($fuelConsumptionInLiterPer100Km)), __LINE__);
        }
        $this->FuelConsumptionInLiterPer100Km = $fuelConsumptionInLiterPer100Km;
        return $this;
    }
    /**
     * Get FuelConsumptionInKmPerLiter value
     * @return float
     */
    public function getFuelConsumptionInKmPerLiter()
    {
        return $this->FuelConsumptionInKmPerLiter;
    }
    /**
     * Set FuelConsumptionInKmPerLiter value
     * @param float $fuelConsumptionInKmPerLiter
     * @return \StructType\EcoMonitorMaxGearResult
     */
    public function setFuelConsumptionInKmPerLiter($fuelConsumptionInKmPerLiter = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionInKmPerLiter) && !(is_float($fuelConsumptionInKmPerLiter) || is_numeric($fuelConsumptionInKmPerLiter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionInKmPerLiter, true), gettype($fuelConsumptionInKmPerLiter)), __LINE__);
        }
        $this->FuelConsumptionInKmPerLiter = $fuelConsumptionInKmPerLiter;
        return $this;
    }
    /**
     * Get DurationInSec value
     * @return int
     */
    public function getDurationInSec()
    {
        return $this->DurationInSec;
    }
    /**
     * Set DurationInSec value
     * @param int $durationInSec
     * @return \StructType\EcoMonitorMaxGearResult
     */
    public function setDurationInSec($durationInSec = null)
    {
        // validation for constraint: int
        if (!is_null($durationInSec) && !(is_int($durationInSec) || ctype_digit($durationInSec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationInSec, true), gettype($durationInSec)), __LINE__);
        }
        $this->DurationInSec = $durationInSec;
        return $this;
    }
}
