<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorIdlingResult StructType
 * @subpackage Structs
 */
class EcoMonitorIdlingResult extends AbstractStructBase
{
    /**
     * The NumberOfLongIdling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfLongIdling;
    /**
     * The FuelConsumptionIdling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionIdling;
    /**
     * The DurationIdling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationIdling;
    /**
     * The DurationIdlingPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationIdlingPercentage;
    /**
     * Constructor method for EcoMonitorIdlingResult
     * @uses EcoMonitorIdlingResult::setNumberOfLongIdling()
     * @uses EcoMonitorIdlingResult::setFuelConsumptionIdling()
     * @uses EcoMonitorIdlingResult::setDurationIdling()
     * @uses EcoMonitorIdlingResult::setDurationIdlingPercentage()
     * @param int $numberOfLongIdling
     * @param float $fuelConsumptionIdling
     * @param float $durationIdling
     * @param float $durationIdlingPercentage
     */
    public function __construct($numberOfLongIdling = null, $fuelConsumptionIdling = null, $durationIdling = null, $durationIdlingPercentage = null)
    {
        $this
            ->setNumberOfLongIdling($numberOfLongIdling)
            ->setFuelConsumptionIdling($fuelConsumptionIdling)
            ->setDurationIdling($durationIdling)
            ->setDurationIdlingPercentage($durationIdlingPercentage);
    }
    /**
     * Get NumberOfLongIdling value
     * @return int
     */
    public function getNumberOfLongIdling()
    {
        return $this->NumberOfLongIdling;
    }
    /**
     * Set NumberOfLongIdling value
     * @param int $numberOfLongIdling
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setNumberOfLongIdling($numberOfLongIdling = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLongIdling) && !(is_int($numberOfLongIdling) || ctype_digit($numberOfLongIdling))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfLongIdling, true), gettype($numberOfLongIdling)), __LINE__);
        }
        $this->NumberOfLongIdling = $numberOfLongIdling;
        return $this;
    }
    /**
     * Get FuelConsumptionIdling value
     * @return float
     */
    public function getFuelConsumptionIdling()
    {
        return $this->FuelConsumptionIdling;
    }
    /**
     * Set FuelConsumptionIdling value
     * @param float $fuelConsumptionIdling
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setFuelConsumptionIdling($fuelConsumptionIdling = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionIdling) && !(is_float($fuelConsumptionIdling) || is_numeric($fuelConsumptionIdling))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionIdling, true), gettype($fuelConsumptionIdling)), __LINE__);
        }
        $this->FuelConsumptionIdling = $fuelConsumptionIdling;
        return $this;
    }
    /**
     * Get DurationIdling value
     * @return float
     */
    public function getDurationIdling()
    {
        return $this->DurationIdling;
    }
    /**
     * Set DurationIdling value
     * @param float $durationIdling
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setDurationIdling($durationIdling = null)
    {
        // validation for constraint: float
        if (!is_null($durationIdling) && !(is_float($durationIdling) || is_numeric($durationIdling))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationIdling, true), gettype($durationIdling)), __LINE__);
        }
        $this->DurationIdling = $durationIdling;
        return $this;
    }
    /**
     * Get DurationIdlingPercentage value
     * @return float
     */
    public function getDurationIdlingPercentage()
    {
        return $this->DurationIdlingPercentage;
    }
    /**
     * Set DurationIdlingPercentage value
     * @param float $durationIdlingPercentage
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setDurationIdlingPercentage($durationIdlingPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($durationIdlingPercentage) && !(is_float($durationIdlingPercentage) || is_numeric($durationIdlingPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationIdlingPercentage, true), gettype($durationIdlingPercentage)), __LINE__);
        }
        $this->DurationIdlingPercentage = $durationIdlingPercentage;
        return $this;
    }
}
