<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorGearingResult StructType
 * @subpackage Structs
 */
class EcoMonitorGearingResult extends AbstractStructBase
{
    /**
     * The NumberOfGearChanges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfGearChanges;
    /**
     * The NumberOfGearChangesUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfGearChangesUp;
    /**
     * The PositionOfThrottleAverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PositionOfThrottleAverage;
    /**
     * The PositionOfThrottleMaximum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PositionOfThrottleMaximum;
    /**
     * Constructor method for EcoMonitorGearingResult
     * @uses EcoMonitorGearingResult::setNumberOfGearChanges()
     * @uses EcoMonitorGearingResult::setNumberOfGearChangesUp()
     * @uses EcoMonitorGearingResult::setPositionOfThrottleAverage()
     * @uses EcoMonitorGearingResult::setPositionOfThrottleMaximum()
     * @param int $numberOfGearChanges
     * @param int $numberOfGearChangesUp
     * @param float $positionOfThrottleAverage
     * @param float $positionOfThrottleMaximum
     */
    public function __construct($numberOfGearChanges = null, $numberOfGearChangesUp = null, $positionOfThrottleAverage = null, $positionOfThrottleMaximum = null)
    {
        $this
            ->setNumberOfGearChanges($numberOfGearChanges)
            ->setNumberOfGearChangesUp($numberOfGearChangesUp)
            ->setPositionOfThrottleAverage($positionOfThrottleAverage)
            ->setPositionOfThrottleMaximum($positionOfThrottleMaximum);
    }
    /**
     * Get NumberOfGearChanges value
     * @return int
     */
    public function getNumberOfGearChanges()
    {
        return $this->NumberOfGearChanges;
    }
    /**
     * Set NumberOfGearChanges value
     * @param int $numberOfGearChanges
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setNumberOfGearChanges($numberOfGearChanges = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGearChanges) && !(is_int($numberOfGearChanges) || ctype_digit($numberOfGearChanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGearChanges, true), gettype($numberOfGearChanges)), __LINE__);
        }
        $this->NumberOfGearChanges = $numberOfGearChanges;
        return $this;
    }
    /**
     * Get NumberOfGearChangesUp value
     * @return int
     */
    public function getNumberOfGearChangesUp()
    {
        return $this->NumberOfGearChangesUp;
    }
    /**
     * Set NumberOfGearChangesUp value
     * @param int $numberOfGearChangesUp
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setNumberOfGearChangesUp($numberOfGearChangesUp = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGearChangesUp) && !(is_int($numberOfGearChangesUp) || ctype_digit($numberOfGearChangesUp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGearChangesUp, true), gettype($numberOfGearChangesUp)), __LINE__);
        }
        $this->NumberOfGearChangesUp = $numberOfGearChangesUp;
        return $this;
    }
    /**
     * Get PositionOfThrottleAverage value
     * @return float
     */
    public function getPositionOfThrottleAverage()
    {
        return $this->PositionOfThrottleAverage;
    }
    /**
     * Set PositionOfThrottleAverage value
     * @param float $positionOfThrottleAverage
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setPositionOfThrottleAverage($positionOfThrottleAverage = null)
    {
        // validation for constraint: float
        if (!is_null($positionOfThrottleAverage) && !(is_float($positionOfThrottleAverage) || is_numeric($positionOfThrottleAverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($positionOfThrottleAverage, true), gettype($positionOfThrottleAverage)), __LINE__);
        }
        $this->PositionOfThrottleAverage = $positionOfThrottleAverage;
        return $this;
    }
    /**
     * Get PositionOfThrottleMaximum value
     * @return float
     */
    public function getPositionOfThrottleMaximum()
    {
        return $this->PositionOfThrottleMaximum;
    }
    /**
     * Set PositionOfThrottleMaximum value
     * @param float $positionOfThrottleMaximum
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setPositionOfThrottleMaximum($positionOfThrottleMaximum = null)
    {
        // validation for constraint: float
        if (!is_null($positionOfThrottleMaximum) && !(is_float($positionOfThrottleMaximum) || is_numeric($positionOfThrottleMaximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($positionOfThrottleMaximum, true), gettype($positionOfThrottleMaximum)), __LINE__);
        }
        $this->PositionOfThrottleMaximum = $positionOfThrottleMaximum;
        return $this;
    }
}
