<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorCoastingResult_V2 StructType
 * @subpackage Structs
 */
class EcoMonitorCoastingResult_V2 extends EcoMonitorCoastingResult
{
    /**
     * The DistanceEcoRollInKm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceEcoRollInKm;
    /**
     * The DurationEcoRollInSec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DurationEcoRollInSec;
    /**
     * The DistanceEcoRollInPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceEcoRollInPercentage;
    /**
     * Constructor method for EcoMonitorCoastingResult_V2
     * @uses EcoMonitorCoastingResult_V2::setDistanceEcoRollInKm()
     * @uses EcoMonitorCoastingResult_V2::setDurationEcoRollInSec()
     * @uses EcoMonitorCoastingResult_V2::setDistanceEcoRollInPercentage()
     * @param float $distanceEcoRollInKm
     * @param int $durationEcoRollInSec
     * @param float $distanceEcoRollInPercentage
     */
    public function __construct($distanceEcoRollInKm = null, $durationEcoRollInSec = null, $distanceEcoRollInPercentage = null)
    {
        $this
            ->setDistanceEcoRollInKm($distanceEcoRollInKm)
            ->setDurationEcoRollInSec($durationEcoRollInSec)
            ->setDistanceEcoRollInPercentage($distanceEcoRollInPercentage);
    }
    /**
     * Get DistanceEcoRollInKm value
     * @return float
     */
    public function getDistanceEcoRollInKm()
    {
        return $this->DistanceEcoRollInKm;
    }
    /**
     * Set DistanceEcoRollInKm value
     * @param float $distanceEcoRollInKm
     * @return \StructType\EcoMonitorCoastingResult_V2
     */
    public function setDistanceEcoRollInKm($distanceEcoRollInKm = null)
    {
        // validation for constraint: float
        if (!is_null($distanceEcoRollInKm) && !(is_float($distanceEcoRollInKm) || is_numeric($distanceEcoRollInKm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceEcoRollInKm, true), gettype($distanceEcoRollInKm)), __LINE__);
        }
        $this->DistanceEcoRollInKm = $distanceEcoRollInKm;
        return $this;
    }
    /**
     * Get DurationEcoRollInSec value
     * @return int
     */
    public function getDurationEcoRollInSec()
    {
        return $this->DurationEcoRollInSec;
    }
    /**
     * Set DurationEcoRollInSec value
     * @param int $durationEcoRollInSec
     * @return \StructType\EcoMonitorCoastingResult_V2
     */
    public function setDurationEcoRollInSec($durationEcoRollInSec = null)
    {
        // validation for constraint: int
        if (!is_null($durationEcoRollInSec) && !(is_int($durationEcoRollInSec) || ctype_digit($durationEcoRollInSec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationEcoRollInSec, true), gettype($durationEcoRollInSec)), __LINE__);
        }
        $this->DurationEcoRollInSec = $durationEcoRollInSec;
        return $this;
    }
    /**
     * Get DistanceEcoRollInPercentage value
     * @return float
     */
    public function getDistanceEcoRollInPercentage()
    {
        return $this->DistanceEcoRollInPercentage;
    }
    /**
     * Set DistanceEcoRollInPercentage value
     * @param float $distanceEcoRollInPercentage
     * @return \StructType\EcoMonitorCoastingResult_V2
     */
    public function setDistanceEcoRollInPercentage($distanceEcoRollInPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($distanceEcoRollInPercentage) && !(is_float($distanceEcoRollInPercentage) || is_numeric($distanceEcoRollInPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceEcoRollInPercentage, true), gettype($distanceEcoRollInPercentage)), __LINE__);
        }
        $this->DistanceEcoRollInPercentage = $distanceEcoRollInPercentage;
        return $this;
    }
}
