<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorAnticipationResult_V2 StructType
 * @subpackage Structs
 */
class EcoMonitorAnticipationResult_V2 extends AbstractStructBase
{
    /**
     * The NumberOfStops
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfStops;
    /**
     * The NumberOfBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfBrakes;
    /**
     * The NumberOfPanicBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfPanicBrakes;
    /**
     * The DistanceByBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceByBrakes;
    /**
     * The DurationByBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationByBrakes;
    /**
     * The DurationByRetarder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationByRetarder;
    /**
     * The DurationHighRPMnoFuel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationHighRPMnoFuel;
    /**
     * The DurationHighRPM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationHighRPM;
    /**
     * The DistanceByRetarder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceByRetarder;
    /**
     * The DistanceHighRPMnoFuel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceHighRPMnoFuel;
    /**
     * The NumberOfHarshAccelerations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfHarshAccelerations;
    /**
     * The DurationHarshAcceleration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationHarshAcceleration;
    /**
     * Constructor method for EcoMonitorAnticipationResult_V2
     * @uses EcoMonitorAnticipationResult_V2::setNumberOfStops()
     * @uses EcoMonitorAnticipationResult_V2::setNumberOfBrakes()
     * @uses EcoMonitorAnticipationResult_V2::setNumberOfPanicBrakes()
     * @uses EcoMonitorAnticipationResult_V2::setDistanceByBrakes()
     * @uses EcoMonitorAnticipationResult_V2::setDurationByBrakes()
     * @uses EcoMonitorAnticipationResult_V2::setDurationByRetarder()
     * @uses EcoMonitorAnticipationResult_V2::setDurationHighRPMnoFuel()
     * @uses EcoMonitorAnticipationResult_V2::setDurationHighRPM()
     * @uses EcoMonitorAnticipationResult_V2::setDistanceByRetarder()
     * @uses EcoMonitorAnticipationResult_V2::setDistanceHighRPMnoFuel()
     * @uses EcoMonitorAnticipationResult_V2::setNumberOfHarshAccelerations()
     * @uses EcoMonitorAnticipationResult_V2::setDurationHarshAcceleration()
     * @param int $numberOfStops
     * @param int $numberOfBrakes
     * @param int $numberOfPanicBrakes
     * @param float $distanceByBrakes
     * @param float $durationByBrakes
     * @param float $durationByRetarder
     * @param float $durationHighRPMnoFuel
     * @param float $durationHighRPM
     * @param float $distanceByRetarder
     * @param float $distanceHighRPMnoFuel
     * @param int $numberOfHarshAccelerations
     * @param float $durationHarshAcceleration
     */
    public function __construct($numberOfStops = null, $numberOfBrakes = null, $numberOfPanicBrakes = null, $distanceByBrakes = null, $durationByBrakes = null, $durationByRetarder = null, $durationHighRPMnoFuel = null, $durationHighRPM = null, $distanceByRetarder = null, $distanceHighRPMnoFuel = null, $numberOfHarshAccelerations = null, $durationHarshAcceleration = null)
    {
        $this
            ->setNumberOfStops($numberOfStops)
            ->setNumberOfBrakes($numberOfBrakes)
            ->setNumberOfPanicBrakes($numberOfPanicBrakes)
            ->setDistanceByBrakes($distanceByBrakes)
            ->setDurationByBrakes($durationByBrakes)
            ->setDurationByRetarder($durationByRetarder)
            ->setDurationHighRPMnoFuel($durationHighRPMnoFuel)
            ->setDurationHighRPM($durationHighRPM)
            ->setDistanceByRetarder($distanceByRetarder)
            ->setDistanceHighRPMnoFuel($distanceHighRPMnoFuel)
            ->setNumberOfHarshAccelerations($numberOfHarshAccelerations)
            ->setDurationHarshAcceleration($durationHarshAcceleration);
    }
    /**
     * Get NumberOfStops value
     * @return int
     */
    public function getNumberOfStops()
    {
        return $this->NumberOfStops;
    }
    /**
     * Set NumberOfStops value
     * @param int $numberOfStops
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setNumberOfStops($numberOfStops = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfStops) && !(is_int($numberOfStops) || ctype_digit($numberOfStops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfStops, true), gettype($numberOfStops)), __LINE__);
        }
        $this->NumberOfStops = $numberOfStops;
        return $this;
    }
    /**
     * Get NumberOfBrakes value
     * @return int
     */
    public function getNumberOfBrakes()
    {
        return $this->NumberOfBrakes;
    }
    /**
     * Set NumberOfBrakes value
     * @param int $numberOfBrakes
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setNumberOfBrakes($numberOfBrakes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBrakes) && !(is_int($numberOfBrakes) || ctype_digit($numberOfBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBrakes, true), gettype($numberOfBrakes)), __LINE__);
        }
        $this->NumberOfBrakes = $numberOfBrakes;
        return $this;
    }
    /**
     * Get NumberOfPanicBrakes value
     * @return int
     */
    public function getNumberOfPanicBrakes()
    {
        return $this->NumberOfPanicBrakes;
    }
    /**
     * Set NumberOfPanicBrakes value
     * @param int $numberOfPanicBrakes
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setNumberOfPanicBrakes($numberOfPanicBrakes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPanicBrakes) && !(is_int($numberOfPanicBrakes) || ctype_digit($numberOfPanicBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPanicBrakes, true), gettype($numberOfPanicBrakes)), __LINE__);
        }
        $this->NumberOfPanicBrakes = $numberOfPanicBrakes;
        return $this;
    }
    /**
     * Get DistanceByBrakes value
     * @return float
     */
    public function getDistanceByBrakes()
    {
        return $this->DistanceByBrakes;
    }
    /**
     * Set DistanceByBrakes value
     * @param float $distanceByBrakes
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDistanceByBrakes($distanceByBrakes = null)
    {
        // validation for constraint: float
        if (!is_null($distanceByBrakes) && !(is_float($distanceByBrakes) || is_numeric($distanceByBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceByBrakes, true), gettype($distanceByBrakes)), __LINE__);
        }
        $this->DistanceByBrakes = $distanceByBrakes;
        return $this;
    }
    /**
     * Get DurationByBrakes value
     * @return float
     */
    public function getDurationByBrakes()
    {
        return $this->DurationByBrakes;
    }
    /**
     * Set DurationByBrakes value
     * @param float $durationByBrakes
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDurationByBrakes($durationByBrakes = null)
    {
        // validation for constraint: float
        if (!is_null($durationByBrakes) && !(is_float($durationByBrakes) || is_numeric($durationByBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationByBrakes, true), gettype($durationByBrakes)), __LINE__);
        }
        $this->DurationByBrakes = $durationByBrakes;
        return $this;
    }
    /**
     * Get DurationByRetarder value
     * @return float
     */
    public function getDurationByRetarder()
    {
        return $this->DurationByRetarder;
    }
    /**
     * Set DurationByRetarder value
     * @param float $durationByRetarder
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDurationByRetarder($durationByRetarder = null)
    {
        // validation for constraint: float
        if (!is_null($durationByRetarder) && !(is_float($durationByRetarder) || is_numeric($durationByRetarder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationByRetarder, true), gettype($durationByRetarder)), __LINE__);
        }
        $this->DurationByRetarder = $durationByRetarder;
        return $this;
    }
    /**
     * Get DurationHighRPMnoFuel value
     * @return float
     */
    public function getDurationHighRPMnoFuel()
    {
        return $this->DurationHighRPMnoFuel;
    }
    /**
     * Set DurationHighRPMnoFuel value
     * @param float $durationHighRPMnoFuel
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDurationHighRPMnoFuel($durationHighRPMnoFuel = null)
    {
        // validation for constraint: float
        if (!is_null($durationHighRPMnoFuel) && !(is_float($durationHighRPMnoFuel) || is_numeric($durationHighRPMnoFuel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationHighRPMnoFuel, true), gettype($durationHighRPMnoFuel)), __LINE__);
        }
        $this->DurationHighRPMnoFuel = $durationHighRPMnoFuel;
        return $this;
    }
    /**
     * Get DurationHighRPM value
     * @return float
     */
    public function getDurationHighRPM()
    {
        return $this->DurationHighRPM;
    }
    /**
     * Set DurationHighRPM value
     * @param float $durationHighRPM
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDurationHighRPM($durationHighRPM = null)
    {
        // validation for constraint: float
        if (!is_null($durationHighRPM) && !(is_float($durationHighRPM) || is_numeric($durationHighRPM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationHighRPM, true), gettype($durationHighRPM)), __LINE__);
        }
        $this->DurationHighRPM = $durationHighRPM;
        return $this;
    }
    /**
     * Get DistanceByRetarder value
     * @return float
     */
    public function getDistanceByRetarder()
    {
        return $this->DistanceByRetarder;
    }
    /**
     * Set DistanceByRetarder value
     * @param float $distanceByRetarder
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDistanceByRetarder($distanceByRetarder = null)
    {
        // validation for constraint: float
        if (!is_null($distanceByRetarder) && !(is_float($distanceByRetarder) || is_numeric($distanceByRetarder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceByRetarder, true), gettype($distanceByRetarder)), __LINE__);
        }
        $this->DistanceByRetarder = $distanceByRetarder;
        return $this;
    }
    /**
     * Get DistanceHighRPMnoFuel value
     * @return float
     */
    public function getDistanceHighRPMnoFuel()
    {
        return $this->DistanceHighRPMnoFuel;
    }
    /**
     * Set DistanceHighRPMnoFuel value
     * @param float $distanceHighRPMnoFuel
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDistanceHighRPMnoFuel($distanceHighRPMnoFuel = null)
    {
        // validation for constraint: float
        if (!is_null($distanceHighRPMnoFuel) && !(is_float($distanceHighRPMnoFuel) || is_numeric($distanceHighRPMnoFuel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceHighRPMnoFuel, true), gettype($distanceHighRPMnoFuel)), __LINE__);
        }
        $this->DistanceHighRPMnoFuel = $distanceHighRPMnoFuel;
        return $this;
    }
    /**
     * Get NumberOfHarshAccelerations value
     * @return int
     */
    public function getNumberOfHarshAccelerations()
    {
        return $this->NumberOfHarshAccelerations;
    }
    /**
     * Set NumberOfHarshAccelerations value
     * @param int $numberOfHarshAccelerations
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setNumberOfHarshAccelerations($numberOfHarshAccelerations = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfHarshAccelerations) && !(is_int($numberOfHarshAccelerations) || ctype_digit($numberOfHarshAccelerations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfHarshAccelerations, true), gettype($numberOfHarshAccelerations)), __LINE__);
        }
        $this->NumberOfHarshAccelerations = $numberOfHarshAccelerations;
        return $this;
    }
    /**
     * Get DurationHarshAcceleration value
     * @return float
     */
    public function getDurationHarshAcceleration()
    {
        return $this->DurationHarshAcceleration;
    }
    /**
     * Set DurationHarshAcceleration value
     * @param float $durationHarshAcceleration
     * @return \StructType\EcoMonitorAnticipationResult_V2
     */
    public function setDurationHarshAcceleration($durationHarshAcceleration = null)
    {
        // validation for constraint: float
        if (!is_null($durationHarshAcceleration) && !(is_float($durationHarshAcceleration) || is_numeric($durationHarshAcceleration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationHarshAcceleration, true), gettype($durationHarshAcceleration)), __LINE__);
        }
        $this->DurationHarshAcceleration = $durationHarshAcceleration;
        return $this;
    }
}
