<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorAnticipationResult StructType
 * @subpackage Structs
 */
class EcoMonitorAnticipationResult extends AbstractStructBase
{
    /**
     * The NumberOfStops
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfStops;
    /**
     * The NumberOfBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfBrakes;
    /**
     * The NumberOfPanicBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfPanicBrakes;
    /**
     * The DistanceByBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceByBrakes;
    /**
     * The DurationByBrakes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationByBrakes;
    /**
     * The DurationByRetarder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationByRetarder;
    /**
     * The DurationHighRPMnoFuel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationHighRPMnoFuel;
    /**
     * Constructor method for EcoMonitorAnticipationResult
     * @uses EcoMonitorAnticipationResult::setNumberOfStops()
     * @uses EcoMonitorAnticipationResult::setNumberOfBrakes()
     * @uses EcoMonitorAnticipationResult::setNumberOfPanicBrakes()
     * @uses EcoMonitorAnticipationResult::setDistanceByBrakes()
     * @uses EcoMonitorAnticipationResult::setDurationByBrakes()
     * @uses EcoMonitorAnticipationResult::setDurationByRetarder()
     * @uses EcoMonitorAnticipationResult::setDurationHighRPMnoFuel()
     * @param int $numberOfStops
     * @param int $numberOfBrakes
     * @param int $numberOfPanicBrakes
     * @param float $distanceByBrakes
     * @param float $durationByBrakes
     * @param float $durationByRetarder
     * @param float $durationHighRPMnoFuel
     */
    public function __construct($numberOfStops = null, $numberOfBrakes = null, $numberOfPanicBrakes = null, $distanceByBrakes = null, $durationByBrakes = null, $durationByRetarder = null, $durationHighRPMnoFuel = null)
    {
        $this
            ->setNumberOfStops($numberOfStops)
            ->setNumberOfBrakes($numberOfBrakes)
            ->setNumberOfPanicBrakes($numberOfPanicBrakes)
            ->setDistanceByBrakes($distanceByBrakes)
            ->setDurationByBrakes($durationByBrakes)
            ->setDurationByRetarder($durationByRetarder)
            ->setDurationHighRPMnoFuel($durationHighRPMnoFuel);
    }
    /**
     * Get NumberOfStops value
     * @return int
     */
    public function getNumberOfStops()
    {
        return $this->NumberOfStops;
    }
    /**
     * Set NumberOfStops value
     * @param int $numberOfStops
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setNumberOfStops($numberOfStops = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfStops) && !(is_int($numberOfStops) || ctype_digit($numberOfStops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfStops, true), gettype($numberOfStops)), __LINE__);
        }
        $this->NumberOfStops = $numberOfStops;
        return $this;
    }
    /**
     * Get NumberOfBrakes value
     * @return int
     */
    public function getNumberOfBrakes()
    {
        return $this->NumberOfBrakes;
    }
    /**
     * Set NumberOfBrakes value
     * @param int $numberOfBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setNumberOfBrakes($numberOfBrakes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBrakes) && !(is_int($numberOfBrakes) || ctype_digit($numberOfBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBrakes, true), gettype($numberOfBrakes)), __LINE__);
        }
        $this->NumberOfBrakes = $numberOfBrakes;
        return $this;
    }
    /**
     * Get NumberOfPanicBrakes value
     * @return int
     */
    public function getNumberOfPanicBrakes()
    {
        return $this->NumberOfPanicBrakes;
    }
    /**
     * Set NumberOfPanicBrakes value
     * @param int $numberOfPanicBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setNumberOfPanicBrakes($numberOfPanicBrakes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPanicBrakes) && !(is_int($numberOfPanicBrakes) || ctype_digit($numberOfPanicBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPanicBrakes, true), gettype($numberOfPanicBrakes)), __LINE__);
        }
        $this->NumberOfPanicBrakes = $numberOfPanicBrakes;
        return $this;
    }
    /**
     * Get DistanceByBrakes value
     * @return float
     */
    public function getDistanceByBrakes()
    {
        return $this->DistanceByBrakes;
    }
    /**
     * Set DistanceByBrakes value
     * @param float $distanceByBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDistanceByBrakes($distanceByBrakes = null)
    {
        // validation for constraint: float
        if (!is_null($distanceByBrakes) && !(is_float($distanceByBrakes) || is_numeric($distanceByBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceByBrakes, true), gettype($distanceByBrakes)), __LINE__);
        }
        $this->DistanceByBrakes = $distanceByBrakes;
        return $this;
    }
    /**
     * Get DurationByBrakes value
     * @return float
     */
    public function getDurationByBrakes()
    {
        return $this->DurationByBrakes;
    }
    /**
     * Set DurationByBrakes value
     * @param float $durationByBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDurationByBrakes($durationByBrakes = null)
    {
        // validation for constraint: float
        if (!is_null($durationByBrakes) && !(is_float($durationByBrakes) || is_numeric($durationByBrakes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationByBrakes, true), gettype($durationByBrakes)), __LINE__);
        }
        $this->DurationByBrakes = $durationByBrakes;
        return $this;
    }
    /**
     * Get DurationByRetarder value
     * @return float
     */
    public function getDurationByRetarder()
    {
        return $this->DurationByRetarder;
    }
    /**
     * Set DurationByRetarder value
     * @param float $durationByRetarder
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDurationByRetarder($durationByRetarder = null)
    {
        // validation for constraint: float
        if (!is_null($durationByRetarder) && !(is_float($durationByRetarder) || is_numeric($durationByRetarder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationByRetarder, true), gettype($durationByRetarder)), __LINE__);
        }
        $this->DurationByRetarder = $durationByRetarder;
        return $this;
    }
    /**
     * Get DurationHighRPMnoFuel value
     * @return float
     */
    public function getDurationHighRPMnoFuel()
    {
        return $this->DurationHighRPMnoFuel;
    }
    /**
     * Set DurationHighRPMnoFuel value
     * @param float $durationHighRPMnoFuel
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDurationHighRPMnoFuel($durationHighRPMnoFuel = null)
    {
        // validation for constraint: float
        if (!is_null($durationHighRPMnoFuel) && !(is_float($durationHighRPMnoFuel) || is_numeric($durationHighRPMnoFuel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationHighRPMnoFuel, true), gettype($durationHighRPMnoFuel)), __LINE__);
        }
        $this->DurationHighRPMnoFuel = $durationHighRPMnoFuel;
        return $this;
    }
}
