<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoAssistantItem StructType
 * @subpackage Structs
 */
class EcoAssistantItem extends AbstractStructBase
{
    /**
     * The SpeedPenalties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SpeedPenalties;
    /**
     * The RpmPenalties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RpmPenalties;
    /**
     * The AnticipationPenalties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnticipationPenalties;
    /**
     * The IdlingPenalties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IdlingPenalties;
    /**
     * The TotalPenalties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalPenalties;
    /**
     * Constructor method for EcoAssistantItem
     * @uses EcoAssistantItem::setSpeedPenalties()
     * @uses EcoAssistantItem::setRpmPenalties()
     * @uses EcoAssistantItem::setAnticipationPenalties()
     * @uses EcoAssistantItem::setIdlingPenalties()
     * @uses EcoAssistantItem::setTotalPenalties()
     * @param int $speedPenalties
     * @param int $rpmPenalties
     * @param int $anticipationPenalties
     * @param int $idlingPenalties
     * @param int $totalPenalties
     */
    public function __construct($speedPenalties = null, $rpmPenalties = null, $anticipationPenalties = null, $idlingPenalties = null, $totalPenalties = null)
    {
        $this
            ->setSpeedPenalties($speedPenalties)
            ->setRpmPenalties($rpmPenalties)
            ->setAnticipationPenalties($anticipationPenalties)
            ->setIdlingPenalties($idlingPenalties)
            ->setTotalPenalties($totalPenalties);
    }
    /**
     * Get SpeedPenalties value
     * @return int
     */
    public function getSpeedPenalties()
    {
        return $this->SpeedPenalties;
    }
    /**
     * Set SpeedPenalties value
     * @param int $speedPenalties
     * @return \StructType\EcoAssistantItem
     */
    public function setSpeedPenalties($speedPenalties = null)
    {
        // validation for constraint: int
        if (!is_null($speedPenalties) && !(is_int($speedPenalties) || ctype_digit($speedPenalties))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speedPenalties, true), gettype($speedPenalties)), __LINE__);
        }
        $this->SpeedPenalties = $speedPenalties;
        return $this;
    }
    /**
     * Get RpmPenalties value
     * @return int
     */
    public function getRpmPenalties()
    {
        return $this->RpmPenalties;
    }
    /**
     * Set RpmPenalties value
     * @param int $rpmPenalties
     * @return \StructType\EcoAssistantItem
     */
    public function setRpmPenalties($rpmPenalties = null)
    {
        // validation for constraint: int
        if (!is_null($rpmPenalties) && !(is_int($rpmPenalties) || ctype_digit($rpmPenalties))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rpmPenalties, true), gettype($rpmPenalties)), __LINE__);
        }
        $this->RpmPenalties = $rpmPenalties;
        return $this;
    }
    /**
     * Get AnticipationPenalties value
     * @return int
     */
    public function getAnticipationPenalties()
    {
        return $this->AnticipationPenalties;
    }
    /**
     * Set AnticipationPenalties value
     * @param int $anticipationPenalties
     * @return \StructType\EcoAssistantItem
     */
    public function setAnticipationPenalties($anticipationPenalties = null)
    {
        // validation for constraint: int
        if (!is_null($anticipationPenalties) && !(is_int($anticipationPenalties) || ctype_digit($anticipationPenalties))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anticipationPenalties, true), gettype($anticipationPenalties)), __LINE__);
        }
        $this->AnticipationPenalties = $anticipationPenalties;
        return $this;
    }
    /**
     * Get IdlingPenalties value
     * @return int
     */
    public function getIdlingPenalties()
    {
        return $this->IdlingPenalties;
    }
    /**
     * Set IdlingPenalties value
     * @param int $idlingPenalties
     * @return \StructType\EcoAssistantItem
     */
    public function setIdlingPenalties($idlingPenalties = null)
    {
        // validation for constraint: int
        if (!is_null($idlingPenalties) && !(is_int($idlingPenalties) || ctype_digit($idlingPenalties))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idlingPenalties, true), gettype($idlingPenalties)), __LINE__);
        }
        $this->IdlingPenalties = $idlingPenalties;
        return $this;
    }
    /**
     * Get TotalPenalties value
     * @return int
     */
    public function getTotalPenalties()
    {
        return $this->TotalPenalties;
    }
    /**
     * Set TotalPenalties value
     * @param int $totalPenalties
     * @return \StructType\EcoAssistantItem
     */
    public function setTotalPenalties($totalPenalties = null)
    {
        // validation for constraint: int
        if (!is_null($totalPenalties) && !(is_int($totalPenalties) || ctype_digit($totalPenalties))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPenalties, true), gettype($totalPenalties)), __LINE__);
        }
        $this->TotalPenalties = $totalPenalties;
        return $this;
    }
}
