<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverSelection StructType
 * @subpackage Structs
 */
class DriverSelection extends AbstractStructBase
{
    /**
     * The IncludeInactiveDrivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeInactiveDrivers;
    /**
     * The IncludeHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeHistory;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileType;
    /**
     * The PersonList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $PersonList;
    /**
     * Constructor method for DriverSelection
     * @uses DriverSelection::setIncludeInactiveDrivers()
     * @uses DriverSelection::setIncludeHistory()
     * @uses DriverSelection::setProfileType()
     * @uses DriverSelection::setPersonList()
     * @param bool $includeInactiveDrivers
     * @param bool $includeHistory
     * @param string $profileType
     * @param \ArrayType\ArrayOfIdentifier $personList
     */
    public function __construct($includeInactiveDrivers = null, $includeHistory = null, $profileType = null, \ArrayType\ArrayOfIdentifier $personList = null)
    {
        $this
            ->setIncludeInactiveDrivers($includeInactiveDrivers)
            ->setIncludeHistory($includeHistory)
            ->setProfileType($profileType)
            ->setPersonList($personList);
    }
    /**
     * Get IncludeInactiveDrivers value
     * @return bool
     */
    public function getIncludeInactiveDrivers()
    {
        return $this->IncludeInactiveDrivers;
    }
    /**
     * Set IncludeInactiveDrivers value
     * @param bool $includeInactiveDrivers
     * @return \StructType\DriverSelection
     */
    public function setIncludeInactiveDrivers($includeInactiveDrivers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactiveDrivers) && !is_bool($includeInactiveDrivers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInactiveDrivers, true), gettype($includeInactiveDrivers)), __LINE__);
        }
        $this->IncludeInactiveDrivers = $includeInactiveDrivers;
        return $this;
    }
    /**
     * Get IncludeHistory value
     * @return bool
     */
    public function getIncludeHistory()
    {
        return $this->IncludeHistory;
    }
    /**
     * Set IncludeHistory value
     * @param bool $includeHistory
     * @return \StructType\DriverSelection
     */
    public function setIncludeHistory($includeHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeHistory) && !is_bool($includeHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeHistory, true), gettype($includeHistory)), __LINE__);
        }
        $this->IncludeHistory = $includeHistory;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\EnumProfileType::valueIsValid()
     * @uses \EnumType\EnumProfileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profileType
     * @return \StructType\DriverSelection
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumProfileType::valueIsValid($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumProfileType', is_array($profileType) ? implode(', ', $profileType) : var_export($profileType, true), implode(', ', \EnumType\EnumProfileType::getValidValues())), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get PersonList value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getPersonList()
    {
        return $this->PersonList;
    }
    /**
     * Set PersonList value
     * @param \ArrayType\ArrayOfIdentifier $personList
     * @return \StructType\DriverSelection
     */
    public function setPersonList(\ArrayType\ArrayOfIdentifier $personList = null)
    {
        $this->PersonList = $personList;
        return $this;
    }
}
