<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverGroupItem StructType
 * @subpackage Structs
 */
class DriverGroupItem extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * The DriverSubGroupList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDriverSubGroupItem
     */
    public $DriverSubGroupList;
    /**
     * Constructor method for DriverGroupItem
     * @uses DriverGroupItem::setGroupCode()
     * @uses DriverGroupItem::setGroupName()
     * @uses DriverGroupItem::setDriverSubGroupList()
     * @param string $groupCode
     * @param string $groupName
     * @param \ArrayType\ArrayOfDriverSubGroupItem $driverSubGroupList
     */
    public function __construct($groupCode = null, $groupName = null, \ArrayType\ArrayOfDriverSubGroupItem $driverSubGroupList = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setGroupName($groupName)
            ->setDriverSubGroupList($driverSubGroupList);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\DriverGroupItem
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \StructType\DriverGroupItem
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Get DriverSubGroupList value
     * @return \ArrayType\ArrayOfDriverSubGroupItem|null
     */
    public function getDriverSubGroupList()
    {
        return $this->DriverSubGroupList;
    }
    /**
     * Set DriverSubGroupList value
     * @param \ArrayType\ArrayOfDriverSubGroupItem $driverSubGroupList
     * @return \StructType\DriverGroupItem
     */
    public function setDriverSubGroupList(\ArrayType\ArrayOfDriverSubGroupItem $driverSubGroupList = null)
    {
        $this->DriverSubGroupList = $driverSubGroupList;
        return $this;
    }
}
