<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoorlockCommand StructType
 * @subpackage Structs
 */
class DoorlockCommand extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Trailer;
    /**
     * The CommandList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommand
     */
    public $CommandList;
    /**
     * The MasterCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterCode;
    /**
     * Constructor method for DoorlockCommand
     * @uses DoorlockCommand::setVehicle()
     * @uses DoorlockCommand::setTrailer()
     * @uses DoorlockCommand::setCommandList()
     * @uses DoorlockCommand::setMasterCode()
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\IdentifierVehicle $trailer
     * @param \ArrayType\ArrayOfCommand $commandList
     * @param string $masterCode
     */
    public function __construct(\StructType\IdentifierVehicle $vehicle = null, \StructType\IdentifierVehicle $trailer = null, \ArrayType\ArrayOfCommand $commandList = null, $masterCode = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setCommandList($commandList)
            ->setMasterCode($masterCode);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\DoorlockCommand
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicle $trailer
     * @return \StructType\DoorlockCommand
     */
    public function setTrailer(\StructType\IdentifierVehicle $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get CommandList value
     * @return \ArrayType\ArrayOfCommand|null
     */
    public function getCommandList()
    {
        return $this->CommandList;
    }
    /**
     * Set CommandList value
     * @param \ArrayType\ArrayOfCommand $commandList
     * @return \StructType\DoorlockCommand
     */
    public function setCommandList(\ArrayType\ArrayOfCommand $commandList = null)
    {
        $this->CommandList = $commandList;
        return $this;
    }
    /**
     * Get MasterCode value
     * @return string|null
     */
    public function getMasterCode()
    {
        return $this->MasterCode;
    }
    /**
     * Set MasterCode value
     * @param string $masterCode
     * @return \StructType\DoorlockCommand
     */
    public function setMasterCode($masterCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterCode) && !is_string($masterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCode, true), gettype($masterCode)), __LINE__);
        }
        $this->MasterCode = $masterCode;
        return $this;
    }
}
