<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentsResult_V5 StructType
 * @subpackage Structs
 */
class DocumentsResult_V5 extends Document_V7
{
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The SynchronizationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SynchronizationId;
    /**
     * Constructor method for DocumentsResult_V5
     * @uses DocumentsResult_V5::setSynchronizationDate()
     * @uses DocumentsResult_V5::setSynchronizationId()
     * @param string $synchronizationDate
     * @param int $synchronizationId
     */
    public function __construct($synchronizationDate = null, $synchronizationId = null)
    {
        $this
            ->setSynchronizationDate($synchronizationDate)
            ->setSynchronizationId($synchronizationId);
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\DocumentsResult_V5
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get SynchronizationId value
     * @return int
     */
    public function getSynchronizationId()
    {
        return $this->SynchronizationId;
    }
    /**
     * Set SynchronizationId value
     * @param int $synchronizationId
     * @return \StructType\DocumentsResult_V5
     */
    public function setSynchronizationId($synchronizationId = null)
    {
        // validation for constraint: int
        if (!is_null($synchronizationId) && !(is_int($synchronizationId) || ctype_digit($synchronizationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($synchronizationId, true), gettype($synchronizationId)), __LINE__);
        }
        $this->SynchronizationId = $synchronizationId;
        return $this;
    }
}
