<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document_V7 StructType
 * @subpackage Structs
 */
class Document_V7 extends AbstractStructBase
{
    /**
     * The ScanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScanID;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ScannedPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScannedPages;
    /**
     * The ScanDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ScanDate;
    /**
     * The SerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The TypeDoc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDoc;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Job
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JobIdentifier
     */
    public $Job;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductIdentifier
     */
    public $Product;
    /**
     * Constructor method for Document_V7
     * @uses Document_V7::setScanID()
     * @uses Document_V7::setCreationDate()
     * @uses Document_V7::setScannedPages()
     * @uses Document_V7::setScanDate()
     * @uses Document_V7::setSerialNumber()
     * @uses Document_V7::setFileName()
     * @uses Document_V7::setPlace()
     * @uses Document_V7::setVehicle()
     * @uses Document_V7::setDriver()
     * @uses Document_V7::setTrip()
     * @uses Document_V7::setPosition()
     * @uses Document_V7::setTypeDoc()
     * @uses Document_V7::setActivity()
     * @uses Document_V7::setComment()
     * @uses Document_V7::setJob()
     * @uses Document_V7::setProduct()
     * @param int $scanID
     * @param string $creationDate
     * @param int $scannedPages
     * @param string $scanDate
     * @param string $serialNumber
     * @param string $fileName
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\PositionResult $position
     * @param string $typeDoc
     * @param \StructType\Activity $activity
     * @param string $comment
     * @param \StructType\JobIdentifier $job
     * @param \StructType\ProductIdentifier $product
     */
    public function __construct($scanID = null, $creationDate = null, $scannedPages = null, $scanDate = null, $serialNumber = null, $fileName = null, \StructType\PlaceIdentifier $place = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null, \StructType\TripIdentifier $trip = null, \StructType\PositionResult $position = null, $typeDoc = null, \StructType\Activity $activity = null, $comment = null, \StructType\JobIdentifier $job = null, \StructType\ProductIdentifier $product = null)
    {
        $this
            ->setScanID($scanID)
            ->setCreationDate($creationDate)
            ->setScannedPages($scannedPages)
            ->setScanDate($scanDate)
            ->setSerialNumber($serialNumber)
            ->setFileName($fileName)
            ->setPlace($place)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setTrip($trip)
            ->setPosition($position)
            ->setTypeDoc($typeDoc)
            ->setActivity($activity)
            ->setComment($comment)
            ->setJob($job)
            ->setProduct($product);
    }
    /**
     * Get ScanID value
     * @return int
     */
    public function getScanID()
    {
        return $this->ScanID;
    }
    /**
     * Set ScanID value
     * @param int $scanID
     * @return \StructType\Document_V7
     */
    public function setScanID($scanID = null)
    {
        // validation for constraint: int
        if (!is_null($scanID) && !(is_int($scanID) || ctype_digit($scanID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scanID, true), gettype($scanID)), __LINE__);
        }
        $this->ScanID = $scanID;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Document_V7
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ScannedPages value
     * @return int
     */
    public function getScannedPages()
    {
        return $this->ScannedPages;
    }
    /**
     * Set ScannedPages value
     * @param int $scannedPages
     * @return \StructType\Document_V7
     */
    public function setScannedPages($scannedPages = null)
    {
        // validation for constraint: int
        if (!is_null($scannedPages) && !(is_int($scannedPages) || ctype_digit($scannedPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scannedPages, true), gettype($scannedPages)), __LINE__);
        }
        $this->ScannedPages = $scannedPages;
        return $this;
    }
    /**
     * Get ScanDate value
     * @return string
     */
    public function getScanDate()
    {
        return $this->ScanDate;
    }
    /**
     * Set ScanDate value
     * @param string $scanDate
     * @return \StructType\Document_V7
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanDate, true), gettype($scanDate)), __LINE__);
        }
        $this->ScanDate = $scanDate;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \StructType\Document_V7
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\Document_V7
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\Document_V7
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\Document_V7
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\Document_V7
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\Document_V7
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\Document_V7
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @param string $typeDoc
     * @return \StructType\Document_V7
     */
    public function setTypeDoc($typeDoc = null)
    {
        // validation for constraint: string
        if (!is_null($typeDoc) && !is_string($typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDoc, true), gettype($typeDoc)), __LINE__);
        }
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Document_V7
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Document_V7
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Job value
     * @return \StructType\JobIdentifier|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\JobIdentifier $job
     * @return \StructType\Document_V7
     */
    public function setJob(\StructType\JobIdentifier $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\ProductIdentifier|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\ProductIdentifier $product
     * @return \StructType\Document_V7
     */
    public function setProduct(\StructType\ProductIdentifier $product = null)
    {
        $this->Product = $product;
        return $this;
    }
}
