<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistanceReportItem_v2 StructType
 * @subpackage Structs
 */
class DistanceReportItem_v2 extends DistanceReportItem
{
    /**
     * The Consumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The Consumption_L_Per_100km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_L_Per_100km;
    /**
     * The Consumption_Km_Per_L
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_Km_Per_L;
    /**
     * Constructor method for DistanceReportItem_v2
     * @uses DistanceReportItem_v2::setConsumption()
     * @uses DistanceReportItem_v2::setConsumption_L_Per_100km()
     * @uses DistanceReportItem_v2::setConsumption_Km_Per_L()
     * @param float $consumption
     * @param float $consumption_L_Per_100km
     * @param float $consumption_Km_Per_L
     */
    public function __construct($consumption = null, $consumption_L_Per_100km = null, $consumption_Km_Per_L = null)
    {
        $this
            ->setConsumption($consumption)
            ->setConsumption_L_Per_100km($consumption_L_Per_100km)
            ->setConsumption_Km_Per_L($consumption_Km_Per_L);
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \StructType\DistanceReportItem_v2
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: float
        if (!is_null($consumption) && !(is_float($consumption) || is_numeric($consumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get consumption_L_Perkm value
     * @return consumption_L_Perkm
     */
    public function getConsumption_L_Per_100km()
    {
        return $this->Consumption_L_Per_100km;
    }
    /**
     * Set consumption_L_Perkm value
     * @param consumption_L_Perkm $consumption_L_Perkm
     * @return \StructType\DistanceReportItem_v2
     */
    public function setConsumption_L_Per_100km($consumption_L_Per_100km = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_L_Per_100km) && !(is_float($consumption_L_Per_100km) || is_numeric($consumption_L_Per_100km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_L_Per_100km, true), gettype($consumption_L_Per_100km)), __LINE__);
        }
        $this->Consumption_L_Per_100km = $consumption_L_Per_100km;
        return $this;
    }
    /**
     * Get Consumption_Km_Per_L value
     * @return float
     */
    public function getConsumption_Km_Per_L()
    {
        return $this->Consumption_Km_Per_L;
    }
    /**
     * Set Consumption_Km_Per_L value
     * @param float $consumption_Km_Per_L
     * @return \StructType\DistanceReportItem_v2
     */
    public function setConsumption_Km_Per_L($consumption_Km_Per_L = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Km_Per_L) && !(is_float($consumption_Km_Per_L) || is_numeric($consumption_Km_Per_L))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Km_Per_L, true), gettype($consumption_Km_Per_L)), __LINE__);
        }
        $this->Consumption_Km_Per_L = $consumption_Km_Per_L;
        return $this;
    }
}
