<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispatcherInsert_V3 StructType
 * @subpackage Structs
 */
class DispatcherInsert_V3 extends DispatcherInsert_V2
{
    /**
     * The UserProfileId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserProfileId;
    /**
     * The UserRightId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserRightId;
    /**
     * The UserProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserProfileName;
    /**
     * The UserRightName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserRightName;
    /**
     * Constructor method for DispatcherInsert_V3
     * @uses DispatcherInsert_V3::setUserProfileId()
     * @uses DispatcherInsert_V3::setUserRightId()
     * @uses DispatcherInsert_V3::setUserProfileName()
     * @uses DispatcherInsert_V3::setUserRightName()
     * @param int $userProfileId
     * @param int $userRightId
     * @param string $userProfileName
     * @param string $userRightName
     */
    public function __construct($userProfileId = null, $userRightId = null, $userProfileName = null, $userRightName = null)
    {
        $this
            ->setUserProfileId($userProfileId)
            ->setUserRightId($userRightId)
            ->setUserProfileName($userProfileName)
            ->setUserRightName($userRightName);
    }
    /**
     * Get UserProfileId value
     * @return int
     */
    public function getUserProfileId()
    {
        return $this->UserProfileId;
    }
    /**
     * Set UserProfileId value
     * @param int $userProfileId
     * @return \StructType\DispatcherInsert_V3
     */
    public function setUserProfileId($userProfileId = null)
    {
        // validation for constraint: int
        if (!is_null($userProfileId) && !(is_int($userProfileId) || ctype_digit($userProfileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userProfileId, true), gettype($userProfileId)), __LINE__);
        }
        $this->UserProfileId = $userProfileId;
        return $this;
    }
    /**
     * Get UserRightId value
     * @return int
     */
    public function getUserRightId()
    {
        return $this->UserRightId;
    }
    /**
     * Set UserRightId value
     * @param int $userRightId
     * @return \StructType\DispatcherInsert_V3
     */
    public function setUserRightId($userRightId = null)
    {
        // validation for constraint: int
        if (!is_null($userRightId) && !(is_int($userRightId) || ctype_digit($userRightId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userRightId, true), gettype($userRightId)), __LINE__);
        }
        $this->UserRightId = $userRightId;
        return $this;
    }
    /**
     * Get UserProfileName value
     * @return string|null
     */
    public function getUserProfileName()
    {
        return $this->UserProfileName;
    }
    /**
     * Set UserProfileName value
     * @param string $userProfileName
     * @return \StructType\DispatcherInsert_V3
     */
    public function setUserProfileName($userProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($userProfileName) && !is_string($userProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userProfileName, true), gettype($userProfileName)), __LINE__);
        }
        $this->UserProfileName = $userProfileName;
        return $this;
    }
    /**
     * Get UserRightName value
     * @return string|null
     */
    public function getUserRightName()
    {
        return $this->UserRightName;
    }
    /**
     * Set UserRightName value
     * @param string $userRightName
     * @return \StructType\DispatcherInsert_V3
     */
    public function setUserRightName($userRightName = null)
    {
        // validation for constraint: string
        if (!is_null($userRightName) && !is_string($userRightName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRightName, true), gettype($userRightName)), __LINE__);
        }
        $this->UserRightName = $userRightName;
        return $this;
    }
}
