<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dispatcher StructType
 * @subpackage Structs
 */
class Dispatcher extends AbstractStructBase
{
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The SexType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SexType;
    /**
     * The PersonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonID;
    /**
     * The PersonExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonExternalCode;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Firstname;
    /**
     * The Lastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lastname;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for Dispatcher
     * @uses Dispatcher::setInactive()
     * @uses Dispatcher::setSexType()
     * @uses Dispatcher::setPersonID()
     * @uses Dispatcher::setPersonExternalCode()
     * @uses Dispatcher::setLanguage()
     * @uses Dispatcher::setFirstname()
     * @uses Dispatcher::setLastname()
     * @uses Dispatcher::setDescription()
     * @uses Dispatcher::setEmail()
     * @uses Dispatcher::setPhone()
     * @uses Dispatcher::setPassword()
     * @param bool $inactive
     * @param string $sexType
     * @param string $personID
     * @param string $personExternalCode
     * @param string $language
     * @param string $firstname
     * @param string $lastname
     * @param string $description
     * @param string $email
     * @param string $phone
     * @param string $password
     */
    public function __construct($inactive = null, $sexType = null, $personID = null, $personExternalCode = null, $language = null, $firstname = null, $lastname = null, $description = null, $email = null, $phone = null, $password = null)
    {
        $this
            ->setInactive($inactive)
            ->setSexType($sexType)
            ->setPersonID($personID)
            ->setPersonExternalCode($personExternalCode)
            ->setLanguage($language)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setDescription($description)
            ->setEmail($email)
            ->setPhone($phone)
            ->setPassword($password);
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Dispatcher
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get SexType value
     * @return string
     */
    public function getSexType()
    {
        return $this->SexType;
    }
    /**
     * Set SexType value
     * @uses \EnumType\EnumSexType::valueIsValid()
     * @uses \EnumType\EnumSexType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sexType
     * @return \StructType\Dispatcher
     */
    public function setSexType($sexType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSexType::valueIsValid($sexType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSexType', is_array($sexType) ? implode(', ', $sexType) : var_export($sexType, true), implode(', ', \EnumType\EnumSexType::getValidValues())), __LINE__);
        }
        $this->SexType = $sexType;
        return $this;
    }
    /**
     * Get PersonID value
     * @return string|null
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param string $personID
     * @return \StructType\Dispatcher
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: string
        if (!is_null($personID) && !is_string($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get PersonExternalCode value
     * @return string|null
     */
    public function getPersonExternalCode()
    {
        return $this->PersonExternalCode;
    }
    /**
     * Set PersonExternalCode value
     * @param string $personExternalCode
     * @return \StructType\Dispatcher
     */
    public function setPersonExternalCode($personExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($personExternalCode) && !is_string($personExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personExternalCode, true), gettype($personExternalCode)), __LINE__);
        }
        $this->PersonExternalCode = $personExternalCode;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Dispatcher
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\Dispatcher
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->Lastname;
    }
    /**
     * Set Lastname value
     * @param string $lastname
     * @return \StructType\Dispatcher
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        $this->Lastname = $lastname;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Dispatcher
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Dispatcher
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\Dispatcher
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Dispatcher
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
