<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteLatest StructType
 * @subpackage Structs
 */
class DeleteLatest extends ProfileActionStrategySelection
{
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileType;
    /**
     * Constructor method for DeleteLatest
     * @uses DeleteLatest::setProfileType()
     * @param string $profileType
     */
    public function __construct($profileType = null)
    {
        $this
            ->setProfileType($profileType);
    }
    /**
     * Get ProfileType value
     * @return string
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\EnumProfileType_V2::valueIsValid()
     * @uses \EnumType\EnumProfileType_V2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profileType
     * @return \StructType\DeleteLatest
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumProfileType_V2::valueIsValid($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumProfileType_V2', is_array($profileType) ? implode(', ', $profileType) : var_export($profileType, true), implode(', ', \EnumType\EnumProfileType_V2::getValidValues())), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
}
