<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeAndIdSelection StructType
 * @subpackage Structs
 */
class DateTimeAndIdSelection extends AbstractStructBase
{
    /**
     * The DateTimeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTimeType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Value;
    /**
     * Constructor method for DateTimeAndIdSelection
     * @uses DateTimeAndIdSelection::setDateTimeType()
     * @uses DateTimeAndIdSelection::setValue()
     * @param string $dateTimeType
     * @param int $value
     */
    public function __construct($dateTimeType = null, $value = null)
    {
        $this
            ->setDateTimeType($dateTimeType)
            ->setValue($value);
    }
    /**
     * Get DateTimeType value
     * @return string
     */
    public function getDateTimeType()
    {
        return $this->DateTimeType;
    }
    /**
     * Set DateTimeType value
     * @uses \EnumType\EnumSelectionDateTimeAndIdType::valueIsValid()
     * @uses \EnumType\EnumSelectionDateTimeAndIdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateTimeType
     * @return \StructType\DateTimeAndIdSelection
     */
    public function setDateTimeType($dateTimeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSelectionDateTimeAndIdType::valueIsValid($dateTimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSelectionDateTimeAndIdType', is_array($dateTimeType) ? implode(', ', $dateTimeType) : var_export($dateTimeType, true), implode(', ', \EnumType\EnumSelectionDateTimeAndIdType::getValidValues())), __LINE__);
        }
        $this->DateTimeType = $dateTimeType;
        return $this;
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \StructType\DateTimeAndIdSelection
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
