<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrentTrip StructType
 * @subpackage Structs
 */
class CurrentTrip extends AbstractStructBase
{
    /**
     * The StartTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The TripStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TripStatus;
    /**
     * The TripID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripID;
    /**
     * The DriverDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * Constructor method for CurrentTrip
     * @uses CurrentTrip::setStartTime()
     * @uses CurrentTrip::setTripStatus()
     * @uses CurrentTrip::setTripID()
     * @uses CurrentTrip::setDriverDisplay()
     * @param string $startTime
     * @param string $tripStatus
     * @param string $tripID
     * @param string $driverDisplay
     */
    public function __construct($startTime = null, $tripStatus = null, $tripID = null, $driverDisplay = null)
    {
        $this
            ->setStartTime($startTime)
            ->setTripStatus($tripStatus)
            ->setTripID($tripID)
            ->setDriverDisplay($driverDisplay);
    }
    /**
     * Get StartTime value
     * @return string
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\CurrentTrip
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get TripStatus value
     * @return string
     */
    public function getTripStatus()
    {
        return $this->TripStatus;
    }
    /**
     * Set TripStatus value
     * @uses \EnumType\EnumTripStatus::valueIsValid()
     * @uses \EnumType\EnumTripStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripStatus
     * @return \StructType\CurrentTrip
     */
    public function setTripStatus($tripStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTripStatus::valueIsValid($tripStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTripStatus', is_array($tripStatus) ? implode(', ', $tripStatus) : var_export($tripStatus, true), implode(', ', \EnumType\EnumTripStatus::getValidValues())), __LINE__);
        }
        $this->TripStatus = $tripStatus;
        return $this;
    }
    /**
     * Get TripID value
     * @return string|null
     */
    public function getTripID()
    {
        return $this->TripID;
    }
    /**
     * Set TripID value
     * @param string $tripID
     * @return \StructType\CurrentTrip
     */
    public function setTripID($tripID = null)
    {
        // validation for constraint: string
        if (!is_null($tripID) && !is_string($tripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripID, true), gettype($tripID)), __LINE__);
        }
        $this->TripID = $tripID;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\CurrentTrip
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDisplay, true), gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
}
