<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrentLocationResult StructType
 * @subpackage Structs
 */
class CurrentLocationResult extends AbstractStructBase
{
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressInfo;
    /**
     * The DistanceFromCapital
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromCapital;
    /**
     * The DistanceFromLargeCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromLargeCity;
    /**
     * The DistanceFromSmallCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromSmallCity;
    /**
     * The DistanceFromPointOfInterest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromPointOfInterest;
    /**
     * Constructor method for CurrentLocationResult
     * @uses CurrentLocationResult::setAddressInfo()
     * @uses CurrentLocationResult::setDistanceFromCapital()
     * @uses CurrentLocationResult::setDistanceFromLargeCity()
     * @uses CurrentLocationResult::setDistanceFromSmallCity()
     * @uses CurrentLocationResult::setDistanceFromPointOfInterest()
     * @param string $addressInfo
     * @param string $distanceFromCapital
     * @param string $distanceFromLargeCity
     * @param string $distanceFromSmallCity
     * @param string $distanceFromPointOfInterest
     */
    public function __construct($addressInfo = null, $distanceFromCapital = null, $distanceFromLargeCity = null, $distanceFromSmallCity = null, $distanceFromPointOfInterest = null)
    {
        $this
            ->setAddressInfo($addressInfo)
            ->setDistanceFromCapital($distanceFromCapital)
            ->setDistanceFromLargeCity($distanceFromLargeCity)
            ->setDistanceFromSmallCity($distanceFromSmallCity)
            ->setDistanceFromPointOfInterest($distanceFromPointOfInterest);
    }
    /**
     * Get AddressInfo value
     * @return string|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param string $addressInfo
     * @return \StructType\CurrentLocationResult
     */
    public function setAddressInfo($addressInfo = null)
    {
        // validation for constraint: string
        if (!is_null($addressInfo) && !is_string($addressInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressInfo, true), gettype($addressInfo)), __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get DistanceFromCapital value
     * @return string|null
     */
    public function getDistanceFromCapital()
    {
        return $this->DistanceFromCapital;
    }
    /**
     * Set DistanceFromCapital value
     * @param string $distanceFromCapital
     * @return \StructType\CurrentLocationResult
     */
    public function setDistanceFromCapital($distanceFromCapital = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromCapital) && !is_string($distanceFromCapital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromCapital, true), gettype($distanceFromCapital)), __LINE__);
        }
        $this->DistanceFromCapital = $distanceFromCapital;
        return $this;
    }
    /**
     * Get DistanceFromLargeCity value
     * @return string|null
     */
    public function getDistanceFromLargeCity()
    {
        return $this->DistanceFromLargeCity;
    }
    /**
     * Set DistanceFromLargeCity value
     * @param string $distanceFromLargeCity
     * @return \StructType\CurrentLocationResult
     */
    public function setDistanceFromLargeCity($distanceFromLargeCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromLargeCity) && !is_string($distanceFromLargeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromLargeCity, true), gettype($distanceFromLargeCity)), __LINE__);
        }
        $this->DistanceFromLargeCity = $distanceFromLargeCity;
        return $this;
    }
    /**
     * Get DistanceFromSmallCity value
     * @return string|null
     */
    public function getDistanceFromSmallCity()
    {
        return $this->DistanceFromSmallCity;
    }
    /**
     * Set DistanceFromSmallCity value
     * @param string $distanceFromSmallCity
     * @return \StructType\CurrentLocationResult
     */
    public function setDistanceFromSmallCity($distanceFromSmallCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromSmallCity) && !is_string($distanceFromSmallCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromSmallCity, true), gettype($distanceFromSmallCity)), __LINE__);
        }
        $this->DistanceFromSmallCity = $distanceFromSmallCity;
        return $this;
    }
    /**
     * Get DistanceFromPointOfInterest value
     * @return string|null
     */
    public function getDistanceFromPointOfInterest()
    {
        return $this->DistanceFromPointOfInterest;
    }
    /**
     * Set DistanceFromPointOfInterest value
     * @param string $distanceFromPointOfInterest
     * @return \StructType\CurrentLocationResult
     */
    public function setDistanceFromPointOfInterest($distanceFromPointOfInterest = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromPointOfInterest) && !is_string($distanceFromPointOfInterest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromPointOfInterest, true), gettype($distanceFromPointOfInterest)), __LINE__);
        }
        $this->DistanceFromPointOfInterest = $distanceFromPointOfInterest;
        return $this;
    }
}
