<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumptionReportSelection StructType
 * @subpackage Structs
 */
class ConsumptionReportSelection extends AbstractStructBase
{
    /**
     * The SummaryLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SummaryLevel;
    /**
     * The DateTimeRangeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * Constructor method for ConsumptionReportSelection
     * @uses ConsumptionReportSelection::setSummaryLevel()
     * @uses ConsumptionReportSelection::setDateTimeRangeSelection()
     * @uses ConsumptionReportSelection::setDrivers()
     * @param string $summaryLevel
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @param \ArrayType\ArrayOfIdentifier $drivers
     */
    public function __construct($summaryLevel = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null, \ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this
            ->setSummaryLevel($summaryLevel)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setDrivers($drivers);
    }
    /**
     * Get SummaryLevel value
     * @return string
     */
    public function getSummaryLevel()
    {
        return $this->SummaryLevel;
    }
    /**
     * Set SummaryLevel value
     * @uses \EnumType\SummaryLevel::valueIsValid()
     * @uses \EnumType\SummaryLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $summaryLevel
     * @return \StructType\ConsumptionReportSelection
     */
    public function setSummaryLevel($summaryLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SummaryLevel::valueIsValid($summaryLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SummaryLevel', is_array($summaryLevel) ? implode(', ', $summaryLevel) : var_export($summaryLevel, true), implode(', ', \EnumType\SummaryLevel::getValidValues())), __LINE__);
        }
        $this->SummaryLevel = $summaryLevel;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\ConsumptionReportSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\ConsumptionReportSelection
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
}
