<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consultation_V5 StructType
 * @subpackage Structs
 */
class Consultation_V5 extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ArrivalDate;
    /**
     * The LeavingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LeavingDate;
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Km;
    /**
     * The ConsultationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ConsultationId;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier_V4
     */
    public $Place;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier_V2
     */
    public $Trip;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for Consultation_V5
     * @uses Consultation_V5::setArrivalDate()
     * @uses Consultation_V5::setLeavingDate()
     * @uses Consultation_V5::setSynchronizationDate()
     * @uses Consultation_V5::setKm()
     * @uses Consultation_V5::setConsultationId()
     * @uses Consultation_V5::setActivity()
     * @uses Consultation_V5::setPlace()
     * @uses Consultation_V5::setTrip()
     * @uses Consultation_V5::setVehicle()
     * @uses Consultation_V5::setDriver()
     * @uses Consultation_V5::setPosition()
     * @param string $arrivalDate
     * @param string $leavingDate
     * @param string $synchronizationDate
     * @param int $km
     * @param int $consultationId
     * @param \StructType\Activity $activity
     * @param \StructType\PlaceIdentifier_V4 $place
     * @param \StructType\TripIdentifier_V2 $trip
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\Position $position
     */
    public function __construct($arrivalDate = null, $leavingDate = null, $synchronizationDate = null, $km = null, $consultationId = null, \StructType\Activity $activity = null, \StructType\PlaceIdentifier_V4 $place = null, \StructType\TripIdentifier_V2 $trip = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\Position $position = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setLeavingDate($leavingDate)
            ->setSynchronizationDate($synchronizationDate)
            ->setKm($km)
            ->setConsultationId($consultationId)
            ->setActivity($activity)
            ->setPlace($place)
            ->setTrip($trip)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setPosition($position);
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\Consultation_V5
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get LeavingDate value
     * @return string
     */
    public function getLeavingDate()
    {
        return $this->LeavingDate;
    }
    /**
     * Set LeavingDate value
     * @param string $leavingDate
     * @return \StructType\Consultation_V5
     */
    public function setLeavingDate($leavingDate = null)
    {
        // validation for constraint: string
        if (!is_null($leavingDate) && !is_string($leavingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leavingDate, true), gettype($leavingDate)), __LINE__);
        }
        $this->LeavingDate = $leavingDate;
        return $this;
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\Consultation_V5
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get Km value
     * @return int
     */
    public function getKm()
    {
        return $this->Km;
    }
    /**
     * Set Km value
     * @param int $km
     * @return \StructType\Consultation_V5
     */
    public function setKm($km = null)
    {
        // validation for constraint: int
        if (!is_null($km) && !(is_int($km) || ctype_digit($km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($km, true), gettype($km)), __LINE__);
        }
        $this->Km = $km;
        return $this;
    }
    /**
     * Get ConsultationId value
     * @return int
     */
    public function getConsultationId()
    {
        return $this->ConsultationId;
    }
    /**
     * Set ConsultationId value
     * @param int $consultationId
     * @return \StructType\Consultation_V5
     */
    public function setConsultationId($consultationId = null)
    {
        // validation for constraint: int
        if (!is_null($consultationId) && !(is_int($consultationId) || ctype_digit($consultationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consultationId, true), gettype($consultationId)), __LINE__);
        }
        $this->ConsultationId = $consultationId;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Consultation_V5
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier_V4|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier_V4 $place
     * @return \StructType\Consultation_V5
     */
    public function setPlace(\StructType\PlaceIdentifier_V4 $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier_V2|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier_V2 $trip
     * @return \StructType\Consultation_V5
     */
    public function setTrip(\StructType\TripIdentifier_V2 $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\Consultation_V5
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\Consultation_V5
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\Consultation_V5
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
