<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyPOIGroupItem StructType
 * @subpackage Structs
 */
class CompanyPOIGroupItem extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * The CompanyPOISubGroupList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCompanyPOISubGroupItem
     */
    public $CompanyPOISubGroupList;
    /**
     * Constructor method for CompanyPOIGroupItem
     * @uses CompanyPOIGroupItem::setGroupCode()
     * @uses CompanyPOIGroupItem::setGroupName()
     * @uses CompanyPOIGroupItem::setCompanyPOISubGroupList()
     * @param string $groupCode
     * @param string $groupName
     * @param \ArrayType\ArrayOfCompanyPOISubGroupItem $companyPOISubGroupList
     */
    public function __construct($groupCode = null, $groupName = null, \ArrayType\ArrayOfCompanyPOISubGroupItem $companyPOISubGroupList = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setGroupName($groupName)
            ->setCompanyPOISubGroupList($companyPOISubGroupList);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\CompanyPOIGroupItem
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \StructType\CompanyPOIGroupItem
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Get CompanyPOISubGroupList value
     * @return \ArrayType\ArrayOfCompanyPOISubGroupItem|null
     */
    public function getCompanyPOISubGroupList()
    {
        return $this->CompanyPOISubGroupList;
    }
    /**
     * Set CompanyPOISubGroupList value
     * @param \ArrayType\ArrayOfCompanyPOISubGroupItem $companyPOISubGroupList
     * @return \StructType\CompanyPOIGroupItem
     */
    public function setCompanyPOISubGroupList(\ArrayType\ArrayOfCompanyPOISubGroupItem $companyPOISubGroupList = null)
    {
        $this->CompanyPOISubGroupList = $companyPOISubGroupList;
        return $this;
    }
}
