<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommentHistoricalResult_V4 StructType
 * @subpackage Structs
 */
class CommentHistoricalResult_V4 extends Comment
{
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier_V4
     */
    public $Place;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * Constructor method for CommentHistoricalResult_V4
     * @uses CommentHistoricalResult_V4::setSynchronizationDate()
     * @uses CommentHistoricalResult_V4::setPlace()
     * @uses CommentHistoricalResult_V4::setVehicle()
     * @uses CommentHistoricalResult_V4::setDriver()
     * @param string $synchronizationDate
     * @param \StructType\PlaceIdentifier_V4 $place
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     */
    public function __construct($synchronizationDate = null, \StructType\PlaceIdentifier_V4 $place = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null)
    {
        $this
            ->setSynchronizationDate($synchronizationDate)
            ->setPlace($place)
            ->setVehicle($vehicle)
            ->setDriver($driver);
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\CommentHistoricalResult_V4
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier_V4|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier_V4 $place
     * @return \StructType\CommentHistoricalResult_V4
     */
    public function setPlace(\StructType\PlaceIdentifier_V4 $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\CommentHistoricalResult_V4
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\CommentHistoricalResult_V4
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
}
