<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * @subpackage Structs
 */
class Comment extends AbstractStructBase
{
    /**
     * The CommentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CommentDate;
    /**
     * The CommentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommentInfo;
    /**
     * Constructor method for Comment
     * @uses Comment::setCommentDate()
     * @uses Comment::setCommentInfo()
     * @param string $commentDate
     * @param string $commentInfo
     */
    public function __construct($commentDate = null, $commentInfo = null)
    {
        $this
            ->setCommentDate($commentDate)
            ->setCommentInfo($commentInfo);
    }
    /**
     * Get CommentDate value
     * @return string
     */
    public function getCommentDate()
    {
        return $this->CommentDate;
    }
    /**
     * Set CommentDate value
     * @param string $commentDate
     * @return \StructType\Comment
     */
    public function setCommentDate($commentDate = null)
    {
        // validation for constraint: string
        if (!is_null($commentDate) && !is_string($commentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentDate, true), gettype($commentDate)), __LINE__);
        }
        $this->CommentDate = $commentDate;
        return $this;
    }
    /**
     * Get CommentInfo value
     * @return string|null
     */
    public function getCommentInfo()
    {
        return $this->CommentInfo;
    }
    /**
     * Set CommentInfo value
     * @param string $commentInfo
     * @return \StructType\Comment
     */
    public function setCommentInfo($commentInfo = null)
    {
        // validation for constraint: string
        if (!is_null($commentInfo) && !is_string($commentInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentInfo, true), gettype($commentInfo)), __LINE__);
        }
        $this->CommentInfo = $commentInfo;
        return $this;
    }
}
