<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code StructType
 * @subpackage Structs
 */
class Code extends AbstractStructBase
{
    /**
     * The ReportCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportCode;
    /**
     * The IntegratorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegratorCode;
    /**
     * Constructor method for Code
     * @uses Code::setReportCode()
     * @uses Code::setIntegratorCode()
     * @param string $reportCode
     * @param string $integratorCode
     */
    public function __construct($reportCode = null, $integratorCode = null)
    {
        $this
            ->setReportCode($reportCode)
            ->setIntegratorCode($integratorCode);
    }
    /**
     * Get ReportCode value
     * @return string|null
     */
    public function getReportCode()
    {
        return $this->ReportCode;
    }
    /**
     * Set ReportCode value
     * @param string $reportCode
     * @return \StructType\Code
     */
    public function setReportCode($reportCode = null)
    {
        // validation for constraint: string
        if (!is_null($reportCode) && !is_string($reportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportCode, true), gettype($reportCode)), __LINE__);
        }
        $this->ReportCode = $reportCode;
        return $this;
    }
    /**
     * Get IntegratorCode value
     * @return string|null
     */
    public function getIntegratorCode()
    {
        return $this->IntegratorCode;
    }
    /**
     * Set IntegratorCode value
     * @param string $integratorCode
     * @return \StructType\Code
     */
    public function setIntegratorCode($integratorCode = null)
    {
        // validation for constraint: string
        if (!is_null($integratorCode) && !is_string($integratorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integratorCode, true), gettype($integratorCode)), __LINE__);
        }
        $this->IntegratorCode = $integratorCode;
        return $this;
    }
}
