<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalibrationDetail StructType
 * @subpackage Structs
 */
class CalibrationDetail extends AbstractStructBase
{
    /**
     * The EmptyWeightInKg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EmptyWeightInKg;
    /**
     * The MaxFuelCapacityInLiter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxFuelCapacityInLiter;
    /**
     * The CalibrationMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CalibrationMethod;
    /**
     * The Empty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CalibrationEmpty
     */
    public $Empty;
    /**
     * The Half
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CalibrationHalf
     */
    public $Half;
    /**
     * The Full
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CalibrationFull
     */
    public $Full;
    /**
     * Constructor method for CalibrationDetail
     * @uses CalibrationDetail::setEmptyWeightInKg()
     * @uses CalibrationDetail::setMaxFuelCapacityInLiter()
     * @uses CalibrationDetail::setCalibrationMethod()
     * @uses CalibrationDetail::setEmpty()
     * @uses CalibrationDetail::setHalf()
     * @uses CalibrationDetail::setFull()
     * @param float $emptyWeightInKg
     * @param float $maxFuelCapacityInLiter
     * @param string $calibrationMethod
     * @param \StructType\CalibrationEmpty $empty
     * @param \StructType\CalibrationHalf $half
     * @param \StructType\CalibrationFull $full
     */
    public function __construct($emptyWeightInKg = null, $maxFuelCapacityInLiter = null, $calibrationMethod = null, \StructType\CalibrationEmpty $empty = null, \StructType\CalibrationHalf $half = null, \StructType\CalibrationFull $full = null)
    {
        $this
            ->setEmptyWeightInKg($emptyWeightInKg)
            ->setMaxFuelCapacityInLiter($maxFuelCapacityInLiter)
            ->setCalibrationMethod($calibrationMethod)
            ->setEmpty($empty)
            ->setHalf($half)
            ->setFull($full);
    }
    /**
     * Get EmptyWeightInKg value
     * @return float
     */
    public function getEmptyWeightInKg()
    {
        return $this->EmptyWeightInKg;
    }
    /**
     * Set EmptyWeightInKg value
     * @param float $emptyWeightInKg
     * @return \StructType\CalibrationDetail
     */
    public function setEmptyWeightInKg($emptyWeightInKg = null)
    {
        // validation for constraint: float
        if (!is_null($emptyWeightInKg) && !(is_float($emptyWeightInKg) || is_numeric($emptyWeightInKg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emptyWeightInKg, true), gettype($emptyWeightInKg)), __LINE__);
        }
        $this->EmptyWeightInKg = $emptyWeightInKg;
        return $this;
    }
    /**
     * Get MaxFuelCapacityInLiter value
     * @return float
     */
    public function getMaxFuelCapacityInLiter()
    {
        return $this->MaxFuelCapacityInLiter;
    }
    /**
     * Set MaxFuelCapacityInLiter value
     * @param float $maxFuelCapacityInLiter
     * @return \StructType\CalibrationDetail
     */
    public function setMaxFuelCapacityInLiter($maxFuelCapacityInLiter = null)
    {
        // validation for constraint: float
        if (!is_null($maxFuelCapacityInLiter) && !(is_float($maxFuelCapacityInLiter) || is_numeric($maxFuelCapacityInLiter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxFuelCapacityInLiter, true), gettype($maxFuelCapacityInLiter)), __LINE__);
        }
        $this->MaxFuelCapacityInLiter = $maxFuelCapacityInLiter;
        return $this;
    }
    /**
     * Get CalibrationMethod value
     * @return string|null
     */
    public function getCalibrationMethod()
    {
        return $this->CalibrationMethod;
    }
    /**
     * Set CalibrationMethod value
     * @param string $calibrationMethod
     * @return \StructType\CalibrationDetail
     */
    public function setCalibrationMethod($calibrationMethod = null)
    {
        // validation for constraint: string
        if (!is_null($calibrationMethod) && !is_string($calibrationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calibrationMethod, true), gettype($calibrationMethod)), __LINE__);
        }
        $this->CalibrationMethod = $calibrationMethod;
        return $this;
    }
    /**
     * Get Empty value
     * @return \StructType\CalibrationEmpty|null
     */
    public function getEmpty()
    {
        return $this->Empty;
    }
    /**
     * Set Empty value
     * @param \StructType\CalibrationEmpty $empty
     * @return \StructType\CalibrationDetail
     */
    public function setEmpty(\StructType\CalibrationEmpty $empty = null)
    {
        $this->Empty = $empty;
        return $this;
    }
    /**
     * Get Half value
     * @return \StructType\CalibrationHalf|null
     */
    public function getHalf()
    {
        return $this->Half;
    }
    /**
     * Set Half value
     * @param \StructType\CalibrationHalf $half
     * @return \StructType\CalibrationDetail
     */
    public function setHalf(\StructType\CalibrationHalf $half = null)
    {
        $this->Half = $half;
        return $this;
    }
    /**
     * Get Full value
     * @return \StructType\CalibrationFull|null
     */
    public function getFull()
    {
        return $this->Full;
    }
    /**
     * Set Full value
     * @param \StructType\CalibrationFull $full
     * @return \StructType\CalibrationDetail
     */
    public function setFull(\StructType\CalibrationFull $full = null)
    {
        $this->Full = $full;
        return $this;
    }
}
