<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalibrationBase StructType
 * @subpackage Structs
 */
class CalibrationBase extends AbstractStructBase
{
    /**
     * The SensorValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SensorValue;
    /**
     * The WeightInKg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WeightInKg;
    /**
     * The SensorUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorUnit;
    /**
     * Constructor method for CalibrationBase
     * @uses CalibrationBase::setSensorValue()
     * @uses CalibrationBase::setWeightInKg()
     * @uses CalibrationBase::setSensorUnit()
     * @param float $sensorValue
     * @param float $weightInKg
     * @param string $sensorUnit
     */
    public function __construct($sensorValue = null, $weightInKg = null, $sensorUnit = null)
    {
        $this
            ->setSensorValue($sensorValue)
            ->setWeightInKg($weightInKg)
            ->setSensorUnit($sensorUnit);
    }
    /**
     * Get SensorValue value
     * @return float
     */
    public function getSensorValue()
    {
        return $this->SensorValue;
    }
    /**
     * Set SensorValue value
     * @param float $sensorValue
     * @return \StructType\CalibrationBase
     */
    public function setSensorValue($sensorValue = null)
    {
        // validation for constraint: float
        if (!is_null($sensorValue) && !(is_float($sensorValue) || is_numeric($sensorValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sensorValue, true), gettype($sensorValue)), __LINE__);
        }
        $this->SensorValue = $sensorValue;
        return $this;
    }
    /**
     * Get WeightInKg value
     * @return float
     */
    public function getWeightInKg()
    {
        return $this->WeightInKg;
    }
    /**
     * Set WeightInKg value
     * @param float $weightInKg
     * @return \StructType\CalibrationBase
     */
    public function setWeightInKg($weightInKg = null)
    {
        // validation for constraint: float
        if (!is_null($weightInKg) && !(is_float($weightInKg) || is_numeric($weightInKg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weightInKg, true), gettype($weightInKg)), __LINE__);
        }
        $this->WeightInKg = $weightInKg;
        return $this;
    }
    /**
     * Get SensorUnit value
     * @return string|null
     */
    public function getSensorUnit()
    {
        return $this->SensorUnit;
    }
    /**
     * Set SensorUnit value
     * @param string $sensorUnit
     * @return \StructType\CalibrationBase
     */
    public function setSensorUnit($sensorUnit = null)
    {
        // validation for constraint: string
        if (!is_null($sensorUnit) && !is_string($sensorUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorUnit, true), gettype($sensorUnit)), __LINE__);
        }
        $this->SensorUnit = $sensorUnit;
        return $this;
    }
}
