<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssignGroupToDispatcher StructType
 * @subpackage Structs
 */
class AssignGroupToDispatcher extends AbstractStructBase
{
    /**
     * The GroupType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupType;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The Dispatcher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Dispatcher;
    /**
     * Constructor method for AssignGroupToDispatcher
     * @uses AssignGroupToDispatcher::setGroupType()
     * @uses AssignGroupToDispatcher::setGroupCode()
     * @uses AssignGroupToDispatcher::setSubGroupCode()
     * @uses AssignGroupToDispatcher::setDispatcher()
     * @param string $groupType
     * @param string $groupCode
     * @param string $subGroupCode
     * @param \StructType\Identifier $dispatcher
     */
    public function __construct($groupType = null, $groupCode = null, $subGroupCode = null, \StructType\Identifier $dispatcher = null)
    {
        $this
            ->setGroupType($groupType)
            ->setGroupCode($groupCode)
            ->setSubGroupCode($subGroupCode)
            ->setDispatcher($dispatcher);
    }
    /**
     * Get GroupType value
     * @return string
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @uses \EnumType\EnumGroupType::valueIsValid()
     * @uses \EnumType\EnumGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\AssignGroupToDispatcher
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGroupType', is_array($groupType) ? implode(', ', $groupType) : var_export($groupType, true), implode(', ', \EnumType\EnumGroupType::getValidValues())), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\AssignGroupToDispatcher
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\AssignGroupToDispatcher
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCode, true), gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\Identifier|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\Identifier $dispatcher
     * @return \StructType\AssignGroupToDispatcher
     */
    public function setDispatcher(\StructType\Identifier $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
}
