<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityTrailerReportItem StructType
 * @subpackage Structs
 */
class ActivityTrailerReportItem extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The BeginMileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BeginMileage;
    /**
     * The EndMileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EndMileage;
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The SynchronizationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SynchronizationId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Trailer;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The POI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\POI
     */
    public $POI;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * Constructor method for ActivityTrailerReportItem
     * @uses ActivityTrailerReportItem::setID()
     * @uses ActivityTrailerReportItem::setBeginDate()
     * @uses ActivityTrailerReportItem::setEndDate()
     * @uses ActivityTrailerReportItem::setBeginMileage()
     * @uses ActivityTrailerReportItem::setEndMileage()
     * @uses ActivityTrailerReportItem::setSynchronizationDate()
     * @uses ActivityTrailerReportItem::setSynchronizationId()
     * @uses ActivityTrailerReportItem::setIsActive()
     * @uses ActivityTrailerReportItem::setTrailer()
     * @uses ActivityTrailerReportItem::setActivity()
     * @uses ActivityTrailerReportItem::setPOI()
     * @uses ActivityTrailerReportItem::setPosition()
     * @param int $iD
     * @param string $beginDate
     * @param string $endDate
     * @param int $beginMileage
     * @param int $endMileage
     * @param string $synchronizationDate
     * @param int $synchronizationId
     * @param bool $isActive
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @param \StructType\Activity $activity
     * @param \StructType\POI $pOI
     * @param \StructType\PositionResult $position
     */
    public function __construct($iD = null, $beginDate = null, $endDate = null, $beginMileage = null, $endMileage = null, $synchronizationDate = null, $synchronizationId = null, $isActive = null, \StructType\IdentifierVehicleResult_V2 $trailer = null, \StructType\Activity $activity = null, \StructType\POI $pOI = null, \StructType\PositionResult $position = null)
    {
        $this
            ->setID($iD)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setBeginMileage($beginMileage)
            ->setEndMileage($endMileage)
            ->setSynchronizationDate($synchronizationDate)
            ->setSynchronizationId($synchronizationId)
            ->setIsActive($isActive)
            ->setTrailer($trailer)
            ->setActivity($activity)
            ->setPOI($pOI)
            ->setPosition($position);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get BeginMileage value
     * @return int
     */
    public function getBeginMileage()
    {
        return $this->BeginMileage;
    }
    /**
     * Set BeginMileage value
     * @param int $beginMileage
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setBeginMileage($beginMileage = null)
    {
        // validation for constraint: int
        if (!is_null($beginMileage) && !(is_int($beginMileage) || ctype_digit($beginMileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($beginMileage, true), gettype($beginMileage)), __LINE__);
        }
        $this->BeginMileage = $beginMileage;
        return $this;
    }
    /**
     * Get EndMileage value
     * @return int
     */
    public function getEndMileage()
    {
        return $this->EndMileage;
    }
    /**
     * Set EndMileage value
     * @param int $endMileage
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setEndMileage($endMileage = null)
    {
        // validation for constraint: int
        if (!is_null($endMileage) && !(is_int($endMileage) || ctype_digit($endMileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endMileage, true), gettype($endMileage)), __LINE__);
        }
        $this->EndMileage = $endMileage;
        return $this;
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get SynchronizationId value
     * @return int
     */
    public function getSynchronizationId()
    {
        return $this->SynchronizationId;
    }
    /**
     * Set SynchronizationId value
     * @param int $synchronizationId
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setSynchronizationId($synchronizationId = null)
    {
        // validation for constraint: int
        if (!is_null($synchronizationId) && !(is_int($synchronizationId) || ctype_digit($synchronizationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($synchronizationId, true), gettype($synchronizationId)), __LINE__);
        }
        $this->SynchronizationId = $synchronizationId;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult_V2 $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get POI value
     * @return \StructType\POI|null
     */
    public function getPOI()
    {
        return $this->POI;
    }
    /**
     * Set POI value
     * @param \StructType\POI $pOI
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setPOI(\StructType\POI $pOI = null)
    {
        $this->POI = $pOI;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\ActivityTrailerReportItem
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
