<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportItem_With_Version_Info StructType
 * @subpackage Structs
 */
class ActivityReportItem_With_Version_Info extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The KmBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmBegin;
    /**
     * The KmEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmEnd;
    /**
     * The Consumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The LoadedStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LoadedStatus;
    /**
     * The SpeedAvg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpeedAvg;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModificationDate;
    /**
     * The WorkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Trailer_External
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $CoDriver;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityInfo_With_Version_Info
     */
    public $Activity;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityRemark
     */
    public $Remarks;
    /**
     * Constructor method for ActivityReportItem_With_Version_Info
     * @uses ActivityReportItem_With_Version_Info::setID()
     * @uses ActivityReportItem_With_Version_Info::setBeginDate()
     * @uses ActivityReportItem_With_Version_Info::setEndDate()
     * @uses ActivityReportItem_With_Version_Info::setKmBegin()
     * @uses ActivityReportItem_With_Version_Info::setKmEnd()
     * @uses ActivityReportItem_With_Version_Info::setConsumption()
     * @uses ActivityReportItem_With_Version_Info::setLoadedStatus()
     * @uses ActivityReportItem_With_Version_Info::setSpeedAvg()
     * @uses ActivityReportItem_With_Version_Info::setModificationDate()
     * @uses ActivityReportItem_With_Version_Info::setWorkingCode()
     * @uses ActivityReportItem_With_Version_Info::setVehicle()
     * @uses ActivityReportItem_With_Version_Info::setTrailer()
     * @uses ActivityReportItem_With_Version_Info::setTrailer_External()
     * @uses ActivityReportItem_With_Version_Info::setDriver()
     * @uses ActivityReportItem_With_Version_Info::setCoDriver()
     * @uses ActivityReportItem_With_Version_Info::setActivity()
     * @uses ActivityReportItem_With_Version_Info::setReference()
     * @uses ActivityReportItem_With_Version_Info::setPlace()
     * @uses ActivityReportItem_With_Version_Info::setTrip()
     * @uses ActivityReportItem_With_Version_Info::setPosition()
     * @uses ActivityReportItem_With_Version_Info::setRemarks()
     * @param int $iD
     * @param string $beginDate
     * @param string $endDate
     * @param int $kmBegin
     * @param int $kmEnd
     * @param float $consumption
     * @param string $loadedStatus
     * @param float $speedAvg
     * @param string $modificationDate
     * @param \StructType\CodeInfo $workingCode
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param string $trailer_External
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierPerson $coDriver
     * @param \StructType\ActivityInfo_With_Version_Info $activity
     * @param string $reference
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\PositionResult $position
     * @param \ArrayType\ArrayOfActivityRemark $remarks
     */
    public function __construct($iD = null, $beginDate = null, $endDate = null, $kmBegin = null, $kmEnd = null, $consumption = null, $loadedStatus = null, $speedAvg = null, $modificationDate = null, \StructType\CodeInfo $workingCode = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, $trailer_External = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierPerson $coDriver = null, \StructType\ActivityInfo_With_Version_Info $activity = null, $reference = null, \StructType\PlaceIdentifier $place = null, \StructType\TripIdentifier $trip = null, \StructType\PositionResult $position = null, \ArrayType\ArrayOfActivityRemark $remarks = null)
    {
        $this
            ->setID($iD)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setKmBegin($kmBegin)
            ->setKmEnd($kmEnd)
            ->setConsumption($consumption)
            ->setLoadedStatus($loadedStatus)
            ->setSpeedAvg($speedAvg)
            ->setModificationDate($modificationDate)
            ->setWorkingCode($workingCode)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setTrailer_External($trailer_External)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setActivity($activity)
            ->setReference($reference)
            ->setPlace($place)
            ->setTrip($trip)
            ->setPosition($position)
            ->setRemarks($remarks);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get KmBegin value
     * @return int
     */
    public function getKmBegin()
    {
        return $this->KmBegin;
    }
    /**
     * Set KmBegin value
     * @param int $kmBegin
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setKmBegin($kmBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmBegin) && !(is_int($kmBegin) || ctype_digit($kmBegin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmBegin, true), gettype($kmBegin)), __LINE__);
        }
        $this->KmBegin = $kmBegin;
        return $this;
    }
    /**
     * Get KmEnd value
     * @return int
     */
    public function getKmEnd()
    {
        return $this->KmEnd;
    }
    /**
     * Set KmEnd value
     * @param int $kmEnd
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setKmEnd($kmEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmEnd) && !(is_int($kmEnd) || ctype_digit($kmEnd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmEnd, true), gettype($kmEnd)), __LINE__);
        }
        $this->KmEnd = $kmEnd;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: float
        if (!is_null($consumption) && !(is_float($consumption) || is_numeric($consumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get LoadedStatus value
     * @return string
     */
    public function getLoadedStatus()
    {
        return $this->LoadedStatus;
    }
    /**
     * Set LoadedStatus value
     * @uses \EnumType\EnumLoadedStatus::valueIsValid()
     * @uses \EnumType\EnumLoadedStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loadedStatus
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setLoadedStatus($loadedStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumLoadedStatus::valueIsValid($loadedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumLoadedStatus', is_array($loadedStatus) ? implode(', ', $loadedStatus) : var_export($loadedStatus, true), implode(', ', \EnumType\EnumLoadedStatus::getValidValues())), __LINE__);
        }
        $this->LoadedStatus = $loadedStatus;
        return $this;
    }
    /**
     * Get SpeedAvg value
     * @return float
     */
    public function getSpeedAvg()
    {
        return $this->SpeedAvg;
    }
    /**
     * Set SpeedAvg value
     * @param float $speedAvg
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setSpeedAvg($speedAvg = null)
    {
        // validation for constraint: float
        if (!is_null($speedAvg) && !(is_float($speedAvg) || is_numeric($speedAvg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speedAvg, true), gettype($speedAvg)), __LINE__);
        }
        $this->SpeedAvg = $speedAvg;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailer_External, true), gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson $coDriver
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setCoDriver(\StructType\IdentifierPerson $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityInfo_With_Version_Info|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityInfo_With_Version_Info $activity
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setActivity(\StructType\ActivityInfo_With_Version_Info $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \ArrayType\ArrayOfActivityRemark|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \ArrayType\ArrayOfActivityRemark $remarks
     * @return \StructType\ActivityReportItem_With_Version_Info
     */
    public function setRemarks(\ArrayType\ArrayOfActivityRemark $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
}
