<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportItem_V7 StructType
 * @subpackage Structs
 */
class ActivityReportItem_V7 extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The KmBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmBegin;
    /**
     * The KmEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmEnd;
    /**
     * The Consumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The LoadedStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LoadedStatus;
    /**
     * The SpeedAvg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpeedAvg;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModificationDate;
    /**
     * The RegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegistrationID;
    /**
     * The WorkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Trailer;
    /**
     * The Trailer_External
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityInfo_With_Version_Info
     */
    public $Activity;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityRemark
     */
    public $Remarks;
    /**
     * The POI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\POI
     */
    public $POI;
    /**
     * Constructor method for ActivityReportItem_V7
     * @uses ActivityReportItem_V7::setID()
     * @uses ActivityReportItem_V7::setBeginDate()
     * @uses ActivityReportItem_V7::setEndDate()
     * @uses ActivityReportItem_V7::setKmBegin()
     * @uses ActivityReportItem_V7::setKmEnd()
     * @uses ActivityReportItem_V7::setConsumption()
     * @uses ActivityReportItem_V7::setLoadedStatus()
     * @uses ActivityReportItem_V7::setSpeedAvg()
     * @uses ActivityReportItem_V7::setModificationDate()
     * @uses ActivityReportItem_V7::setRegistrationID()
     * @uses ActivityReportItem_V7::setWorkingCode()
     * @uses ActivityReportItem_V7::setVehicle()
     * @uses ActivityReportItem_V7::setTrailer()
     * @uses ActivityReportItem_V7::setTrailer_External()
     * @uses ActivityReportItem_V7::setDriver()
     * @uses ActivityReportItem_V7::setCoDriver()
     * @uses ActivityReportItem_V7::setActivity()
     * @uses ActivityReportItem_V7::setReference()
     * @uses ActivityReportItem_V7::setPlace()
     * @uses ActivityReportItem_V7::setTrip()
     * @uses ActivityReportItem_V7::setPosition()
     * @uses ActivityReportItem_V7::setRemarks()
     * @uses ActivityReportItem_V7::setPOI()
     * @param int $iD
     * @param string $beginDate
     * @param string $endDate
     * @param int $kmBegin
     * @param int $kmEnd
     * @param float $consumption
     * @param string $loadedStatus
     * @param float $speedAvg
     * @param string $modificationDate
     * @param int $registrationID
     * @param \StructType\CodeInfo $workingCode
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @param string $trailer_External
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param \StructType\ActivityInfo_With_Version_Info $activity
     * @param string $reference
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\PositionResult $position
     * @param \ArrayType\ArrayOfActivityRemark $remarks
     * @param \StructType\POI $pOI
     */
    public function __construct($iD = null, $beginDate = null, $endDate = null, $kmBegin = null, $kmEnd = null, $consumption = null, $loadedStatus = null, $speedAvg = null, $modificationDate = null, $registrationID = null, \StructType\CodeInfo $workingCode = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierVehicleResult_V2 $trailer = null, $trailer_External = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null, \StructType\ActivityInfo_With_Version_Info $activity = null, $reference = null, \StructType\PlaceIdentifier $place = null, \StructType\TripIdentifier $trip = null, \StructType\PositionResult $position = null, \ArrayType\ArrayOfActivityRemark $remarks = null, \StructType\POI $pOI = null)
    {
        $this
            ->setID($iD)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setKmBegin($kmBegin)
            ->setKmEnd($kmEnd)
            ->setConsumption($consumption)
            ->setLoadedStatus($loadedStatus)
            ->setSpeedAvg($speedAvg)
            ->setModificationDate($modificationDate)
            ->setRegistrationID($registrationID)
            ->setWorkingCode($workingCode)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setTrailer_External($trailer_External)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setActivity($activity)
            ->setReference($reference)
            ->setPlace($place)
            ->setTrip($trip)
            ->setPosition($position)
            ->setRemarks($remarks)
            ->setPOI($pOI);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ActivityReportItem_V7
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\ActivityReportItem_V7
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ActivityReportItem_V7
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get KmBegin value
     * @return int
     */
    public function getKmBegin()
    {
        return $this->KmBegin;
    }
    /**
     * Set KmBegin value
     * @param int $kmBegin
     * @return \StructType\ActivityReportItem_V7
     */
    public function setKmBegin($kmBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmBegin) && !(is_int($kmBegin) || ctype_digit($kmBegin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmBegin, true), gettype($kmBegin)), __LINE__);
        }
        $this->KmBegin = $kmBegin;
        return $this;
    }
    /**
     * Get KmEnd value
     * @return int
     */
    public function getKmEnd()
    {
        return $this->KmEnd;
    }
    /**
     * Set KmEnd value
     * @param int $kmEnd
     * @return \StructType\ActivityReportItem_V7
     */
    public function setKmEnd($kmEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmEnd) && !(is_int($kmEnd) || ctype_digit($kmEnd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmEnd, true), gettype($kmEnd)), __LINE__);
        }
        $this->KmEnd = $kmEnd;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \StructType\ActivityReportItem_V7
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: float
        if (!is_null($consumption) && !(is_float($consumption) || is_numeric($consumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get LoadedStatus value
     * @return string
     */
    public function getLoadedStatus()
    {
        return $this->LoadedStatus;
    }
    /**
     * Set LoadedStatus value
     * @uses \EnumType\EnumLoadedStatus::valueIsValid()
     * @uses \EnumType\EnumLoadedStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loadedStatus
     * @return \StructType\ActivityReportItem_V7
     */
    public function setLoadedStatus($loadedStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumLoadedStatus::valueIsValid($loadedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumLoadedStatus', is_array($loadedStatus) ? implode(', ', $loadedStatus) : var_export($loadedStatus, true), implode(', ', \EnumType\EnumLoadedStatus::getValidValues())), __LINE__);
        }
        $this->LoadedStatus = $loadedStatus;
        return $this;
    }
    /**
     * Get SpeedAvg value
     * @return float
     */
    public function getSpeedAvg()
    {
        return $this->SpeedAvg;
    }
    /**
     * Set SpeedAvg value
     * @param float $speedAvg
     * @return \StructType\ActivityReportItem_V7
     */
    public function setSpeedAvg($speedAvg = null)
    {
        // validation for constraint: float
        if (!is_null($speedAvg) && !(is_float($speedAvg) || is_numeric($speedAvg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speedAvg, true), gettype($speedAvg)), __LINE__);
        }
        $this->SpeedAvg = $speedAvg;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\ActivityReportItem_V7
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return int
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param int $registrationID
     * @return \StructType\ActivityReportItem_V7
     */
    public function setRegistrationID($registrationID = null)
    {
        // validation for constraint: int
        if (!is_null($registrationID) && !(is_int($registrationID) || ctype_digit($registrationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($registrationID, true), gettype($registrationID)), __LINE__);
        }
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\ActivityReportItem_V7
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\ActivityReportItem_V7
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @return \StructType\ActivityReportItem_V7
     */
    public function setTrailer(\StructType\IdentifierVehicleResult_V2 $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\ActivityReportItem_V7
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailer_External, true), gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\ActivityReportItem_V7
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\ActivityReportItem_V7
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityInfo_With_Version_Info|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityInfo_With_Version_Info $activity
     * @return \StructType\ActivityReportItem_V7
     */
    public function setActivity(\StructType\ActivityInfo_With_Version_Info $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ActivityReportItem_V7
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\ActivityReportItem_V7
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\ActivityReportItem_V7
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\ActivityReportItem_V7
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \ArrayType\ArrayOfActivityRemark|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \ArrayType\ArrayOfActivityRemark $remarks
     * @return \StructType\ActivityReportItem_V7
     */
    public function setRemarks(\ArrayType\ArrayOfActivityRemark $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get POI value
     * @return \StructType\POI|null
     */
    public function getPOI()
    {
        return $this->POI;
    }
    /**
     * Set POI value
     * @param \StructType\POI $pOI
     * @return \StructType\ActivityReportItem_V7
     */
    public function setPOI(\StructType\POI $pOI = null)
    {
        $this->POI = $pOI;
        return $this;
    }
}
