<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityRemark StructType
 * @subpackage Structs
 */
class ActivityRemark extends AbstractStructBase
{
    /**
     * The RemarkDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RemarkDate;
    /**
     * The Checked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Checked;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remark;
    /**
     * The Dispatcher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Dispatcher;
    /**
     * Constructor method for ActivityRemark
     * @uses ActivityRemark::setRemarkDate()
     * @uses ActivityRemark::setChecked()
     * @uses ActivityRemark::setSubject()
     * @uses ActivityRemark::setRemark()
     * @uses ActivityRemark::setDispatcher()
     * @param string $remarkDate
     * @param bool $checked
     * @param string $subject
     * @param string $remark
     * @param \StructType\IdentifierPerson $dispatcher
     */
    public function __construct($remarkDate = null, $checked = null, $subject = null, $remark = null, \StructType\IdentifierPerson $dispatcher = null)
    {
        $this
            ->setRemarkDate($remarkDate)
            ->setChecked($checked)
            ->setSubject($subject)
            ->setRemark($remark)
            ->setDispatcher($dispatcher);
    }
    /**
     * Get RemarkDate value
     * @return string
     */
    public function getRemarkDate()
    {
        return $this->RemarkDate;
    }
    /**
     * Set RemarkDate value
     * @param string $remarkDate
     * @return \StructType\ActivityRemark
     */
    public function setRemarkDate($remarkDate = null)
    {
        // validation for constraint: string
        if (!is_null($remarkDate) && !is_string($remarkDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkDate, true), gettype($remarkDate)), __LINE__);
        }
        $this->RemarkDate = $remarkDate;
        return $this;
    }
    /**
     * Get Checked value
     * @return bool
     */
    public function getChecked()
    {
        return $this->Checked;
    }
    /**
     * Set Checked value
     * @param bool $checked
     * @return \StructType\ActivityRemark
     */
    public function setChecked($checked = null)
    {
        // validation for constraint: boolean
        if (!is_null($checked) && !is_bool($checked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checked, true), gettype($checked)), __LINE__);
        }
        $this->Checked = $checked;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\ActivityRemark
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\ActivityRemark
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson $dispatcher
     * @return \StructType\ActivityRemark
     */
    public function setDispatcher(\StructType\IdentifierPerson $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
}
