<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityRange StructType
 * @subpackage Structs
 */
class ActivityRange extends AbstractStructBase
{
    /**
     * The Contract
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Contract;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for ActivityRange
     * @uses ActivityRange::setContract()
     * @uses ActivityRange::setStartDate()
     * @uses ActivityRange::setEndDate()
     * @param string $contract
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($contract = null, $startDate = null, $endDate = null)
    {
        $this
            ->setContract($contract)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get Contract value
     * @return string
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * Set Contract value
     * @uses \EnumType\EnumContractType::valueIsValid()
     * @uses \EnumType\EnumContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contract
     * @return \StructType\ActivityRange
     */
    public function setContract($contract = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumContractType::valueIsValid($contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumContractType', is_array($contract) ? implode(', ', $contract) : var_export($contract, true), implode(', ', \EnumType\EnumContractType::getValidValues())), __LINE__);
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ActivityRange
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ActivityRange
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
}
