<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityPlace StructType
 * @subpackage Structs
 */
class ActivityPlace extends Activity
{
    /**
     * The MaxTimeOfExecution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaxTimeOfExecution;
    /**
     * Constructor method for ActivityPlace
     * @uses ActivityPlace::setMaxTimeOfExecution()
     * @param int $maxTimeOfExecution
     */
    public function __construct($maxTimeOfExecution = null)
    {
        $this
            ->setMaxTimeOfExecution($maxTimeOfExecution);
    }
    /**
     * Get MaxTimeOfExecution value
     * @return int
     */
    public function getMaxTimeOfExecution()
    {
        return $this->MaxTimeOfExecution;
    }
    /**
     * Set MaxTimeOfExecution value
     * @param int $maxTimeOfExecution
     * @return \StructType\ActivityPlace
     */
    public function setMaxTimeOfExecution($maxTimeOfExecution = null)
    {
        // validation for constraint: int
        if (!is_null($maxTimeOfExecution) && !(is_int($maxTimeOfExecution) || ctype_digit($maxTimeOfExecution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTimeOfExecution, true), gettype($maxTimeOfExecution)), __LINE__);
        }
        $this->MaxTimeOfExecution = $maxTimeOfExecution;
        return $this;
    }
}
