<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Cancel_Planning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Planning $parameters
     * @return \StructType\Cancel_PlanningResponse|bool
     */
    public function Cancel_Planning(\StructType\Cancel_Planning $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Planning($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Planning_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Planning_V2 $parameters
     * @return \StructType\Cancel_Planning_V2Response|bool
     */
    public function Cancel_Planning_V2(\StructType\Cancel_Planning_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Planning_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Cancel_PlanningResponse|\StructType\Cancel_Planning_V2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
