<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for GroupTypeV2 EnumType
 * @subpackage Enumerations
 */
class GroupTypeV2 extends AbstractStructEnumBase
{
    /**
     * Constant for value 'VEHICLES'
     * @return string 'VEHICLES'
     */
    const VALUE_VEHICLES = 'VEHICLES';
    /**
     * Constant for value 'DRIVERS'
     * @return string 'DRIVERS'
     */
    const VALUE_DRIVERS = 'DRIVERS';
    /**
     * Constant for value 'TRAILERS'
     * @return string 'TRAILERS'
     */
    const VALUE_TRAILERS = 'TRAILERS';
    /**
     * Constant for value 'POIS'
     * @return string 'POIS'
     */
    const VALUE_POIS = 'POIS';
    /**
     * Return allowed values
     * @uses self::VALUE_VEHICLES
     * @uses self::VALUE_DRIVERS
     * @uses self::VALUE_TRAILERS
     * @uses self::VALUE_POIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VEHICLES,
            self::VALUE_DRIVERS,
            self::VALUE_TRAILERS,
            self::VALUE_POIS,
        );
    }
}
