<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EnumGeoEventType EnumType
 * @subpackage Enumerations
 */
class EnumGeoEventType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Entering'
     * @return string 'Entering'
     */
    const VALUE_ENTERING = 'Entering';
    /**
     * Constant for value 'Leaving'
     * @return string 'Leaving'
     */
    const VALUE_LEAVING = 'Leaving';
    /**
     * Constant for value 'Restrictive'
     * @return string 'Restrictive'
     */
    const VALUE_RESTRICTIVE = 'Restrictive';
    /**
     * Constant for value 'ScheduledTimeOfArrival'
     * @return string 'ScheduledTimeOfArrival'
     */
    const VALUE_SCHEDULED_TIME_OF_ARRIVAL = 'ScheduledTimeOfArrival';
    /**
     * Constant for value 'Stopped'
     * @return string 'Stopped'
     */
    const VALUE_STOPPED = 'Stopped';
    /**
     * Constant for value 'InGeozone'
     * @return string 'InGeozone'
     */
    const VALUE_IN_GEOZONE = 'InGeozone';
    /**
     * Return allowed values
     * @uses self::VALUE_ENTERING
     * @uses self::VALUE_LEAVING
     * @uses self::VALUE_RESTRICTIVE
     * @uses self::VALUE_SCHEDULED_TIME_OF_ARRIVAL
     * @uses self::VALUE_STOPPED
     * @uses self::VALUE_IN_GEOZONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTERING,
            self::VALUE_LEAVING,
            self::VALUE_RESTRICTIVE,
            self::VALUE_SCHEDULED_TIME_OF_ARRIVAL,
            self::VALUE_STOPPED,
            self::VALUE_IN_GEOZONE,
        );
    }
}
