<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTripItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfTripItemResult extends AbstractStructArrayBase
{
    /**
     * The TripItemResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TripItemResult[]
     */
    public $TripItemResult;
    /**
     * Constructor method for ArrayOfTripItemResult
     * @uses ArrayOfTripItemResult::setTripItemResult()
     * @param \StructType\TripItemResult[] $tripItemResult
     */
    public function __construct(array $tripItemResult = array())
    {
        $this
            ->setTripItemResult($tripItemResult);
    }
    /**
     * Get TripItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TripItemResult[]|null
     */
    public function getTripItemResult()
    {
        return isset($this->TripItemResult) ? $this->TripItemResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTripItemResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTripItemResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTripItemResultForArrayConstraintsFromSetTripItemResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTripItemResultTripItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTripItemResultTripItemResultItem instanceof \StructType\TripItemResult) {
                $invalidValues[] = is_object($arrayOfTripItemResultTripItemResultItem) ? get_class($arrayOfTripItemResultTripItemResultItem) : sprintf('%s(%s)', gettype($arrayOfTripItemResultTripItemResultItem), var_export($arrayOfTripItemResultTripItemResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TripItemResult property can only contain items of type \StructType\TripItemResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TripItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TripItemResult[] $tripItemResult
     * @return \ArrayType\ArrayOfTripItemResult
     */
    public function setTripItemResult(array $tripItemResult = array())
    {
        // validation for constraint: array
        if ('' !== ($tripItemResultArrayErrorMessage = self::validateTripItemResultForArrayConstraintsFromSetTripItemResult($tripItemResult))) {
            throw new \InvalidArgumentException($tripItemResultArrayErrorMessage, __LINE__);
        }
        if (is_null($tripItemResult) || (is_array($tripItemResult) && empty($tripItemResult))) {
            unset($this->TripItemResult);
        } else {
            $this->TripItemResult = $tripItemResult;
        }
        return $this;
    }
    /**
     * Add item to TripItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\TripItemResult $item
     * @return \ArrayType\ArrayOfTripItemResult
     */
    public function addToTripItemResult(\StructType\TripItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TripItemResult) {
            throw new \InvalidArgumentException(sprintf('The TripItemResult property can only contain items of type \StructType\TripItemResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TripItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TripItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TripItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TripItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TripItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TripItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TripItemResult
     */
    public function getAttributeName()
    {
        return 'TripItemResult';
    }
}
