<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTemperatureSetting ArrayType
 * @subpackage Arrays
 */
class ArrayOfTemperatureSetting extends AbstractStructArrayBase
{
    /**
     * The TemperatureSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TemperatureSetting[]
     */
    public $TemperatureSetting;
    /**
     * Constructor method for ArrayOfTemperatureSetting
     * @uses ArrayOfTemperatureSetting::setTemperatureSetting()
     * @param \StructType\TemperatureSetting[] $temperatureSetting
     */
    public function __construct(array $temperatureSetting = array())
    {
        $this
            ->setTemperatureSetting($temperatureSetting);
    }
    /**
     * Get TemperatureSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TemperatureSetting[]|null
     */
    public function getTemperatureSetting()
    {
        return isset($this->TemperatureSetting) ? $this->TemperatureSetting : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTemperatureSetting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperatureSetting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureSettingForArrayConstraintsFromSetTemperatureSetting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTemperatureSettingTemperatureSettingItem) {
            // validation for constraint: itemType
            if (!$arrayOfTemperatureSettingTemperatureSettingItem instanceof \StructType\TemperatureSetting) {
                $invalidValues[] = is_object($arrayOfTemperatureSettingTemperatureSettingItem) ? get_class($arrayOfTemperatureSettingTemperatureSettingItem) : sprintf('%s(%s)', gettype($arrayOfTemperatureSettingTemperatureSettingItem), var_export($arrayOfTemperatureSettingTemperatureSettingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TemperatureSetting property can only contain items of type \StructType\TemperatureSetting, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TemperatureSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureSetting[] $temperatureSetting
     * @return \ArrayType\ArrayOfTemperatureSetting
     */
    public function setTemperatureSetting(array $temperatureSetting = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureSettingArrayErrorMessage = self::validateTemperatureSettingForArrayConstraintsFromSetTemperatureSetting($temperatureSetting))) {
            throw new \InvalidArgumentException($temperatureSettingArrayErrorMessage, __LINE__);
        }
        if (is_null($temperatureSetting) || (is_array($temperatureSetting) && empty($temperatureSetting))) {
            unset($this->TemperatureSetting);
        } else {
            $this->TemperatureSetting = $temperatureSetting;
        }
        return $this;
    }
    /**
     * Add item to TemperatureSetting value
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureSetting $item
     * @return \ArrayType\ArrayOfTemperatureSetting
     */
    public function addToTemperatureSetting(\StructType\TemperatureSetting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TemperatureSetting) {
            throw new \InvalidArgumentException(sprintf('The TemperatureSetting property can only contain items of type \StructType\TemperatureSetting, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TemperatureSetting[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TemperatureSetting|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TemperatureSetting|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TemperatureSetting|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TemperatureSetting|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TemperatureSetting|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TemperatureSetting
     */
    public function getAttributeName()
    {
        return 'TemperatureSetting';
    }
}
